/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.holder;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.data.FlowDataSerializer;
import ca.teamdman.sfm.common.flow.data.LineNodeFlowData;
import ca.teamdman.sfm.common.flow.data.RelationshipFlowData;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.util.INBTSerializable;

public class BasicFlowDataContainer
extends Observable
implements INBTSerializable<CompoundNBT> {
    public final int NBT_SCHEMA_VERSION = 2;
    public final String NBT_SCHEMA_VERSION_KEY = "__version";
    public final String NBT_SCHEMA_DATA_KEY = "__data";
    private final HashMap<UUID, FlowData> DELEGATE = new HashMap();

    public Stream<UUID> getDescendants(UUID start, boolean recursive) {
        return SFMUtil.getRecursiveStream((current, next, results) -> this.stream().filter(RelationshipFlowData.class::isInstance).map(RelationshipFlowData.class::cast).filter(rel -> rel.from.equals(current)).map(rel -> this.get(rel.to)).filter(Optional::isPresent).map(Optional::get).forEach(v -> {
            if (v instanceof LineNodeFlowData) {
                next.accept(v.getId());
            } else {
                results.accept(v.getId());
                if (recursive) {
                    next.accept(v.getId());
                }
            }
        }), start);
    }

    public Stream<FlowData> stream() {
        return this.DELEGATE.values().stream();
    }

    public Optional<FlowData> get(UUID id) {
        return Optional.ofNullable(this.DELEGATE.get(id));
    }

    public Stream<UUID> getAncestors(UUID start, boolean recursive) {
        return SFMUtil.getRecursiveStream((current, next, results) -> this.stream().filter(RelationshipFlowData.class::isInstance).map(RelationshipFlowData.class::cast).filter(rel -> rel.to.equals(current)).map(rel -> this.get(rel.from)).filter(Optional::isPresent).map(Optional::get).forEach(v -> {
            if (v instanceof LineNodeFlowData) {
                next.accept(v.getId());
            } else {
                results.accept(v.getId());
                if (recursive) {
                    next.accept(v.getId());
                }
            }
        }), start);
    }

    public FlowData put(FlowData data) {
        FlowData old = this.DELEGATE.put(data.getId(), data);
        this.cleanupObserver(old);
        this.setChanged();
        this.notifyObservers(new FlowDataContainerChange(data, old == null ? FlowDataContainerChange.ChangeType.ADDED : FlowDataContainerChange.ChangeType.UPDATED));
        return old;
    }

    public void cleanupObserver(Object o) {
        if (o instanceof Observer) {
            this.deleteObserver((Observer)o);
        }
    }

    public int size() {
        return this.DELEGATE.size();
    }

    public FlowData remove(UUID key) {
        FlowData data = this.DELEGATE.remove(key);
        if (data != null) {
            this.cleanupObserver(data);
            this.setChanged();
            this.notifyObservers(new FlowDataContainerChange(data, FlowDataContainerChange.ChangeType.REMOVED));
        }
        return data;
    }

    public void notifyGuiClosed() {
        this.setChanged();
        this.notifyObservers(new FlowDataContainerClosedClientEvent());
    }

    public void notifyChanged(FlowData data) {
        this.setChanged();
        this.notifyObservers(new FlowDataContainerChange(data, FlowDataContainerChange.ChangeType.UPDATED));
    }

    public boolean removeIf(Predicate<FlowData> pred) {
        Set<FlowData> removed = this.DELEGATE.values().stream().filter(pred).collect(Collectors.toSet());
        boolean rtn = this.DELEGATE.entrySet().removeIf((? super E entry) -> pred.test((FlowData)entry.getValue()));
        if (rtn) {
            removed.forEach(this::cleanupObserver);
            this.setChanged();
            removed.forEach(data -> this.notifyObservers(new FlowDataContainerChange((FlowData)data, FlowDataContainerChange.ChangeType.REMOVED)));
        }
        return rtn;
    }

    public void clear() {
        ArrayList<FlowData> old = new ArrayList<FlowData>(this.DELEGATE.values());
        this.DELEGATE.clear();
        this.setChanged();
        old.stream().map(data -> new FlowDataContainerChange((FlowData)data, FlowDataContainerChange.ChangeType.REMOVED)).forEach(this::notifyObservers);
    }

    public <T> Optional<T> get(UUID id, Class<T> clazz) {
        return Optional.ofNullable(this.DELEGATE.get(id)).filter(clazz::isInstance).map(clazz::cast);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("__version", 2);
        ListNBT list = new ListNBT();
        this.stream().map(FlowData::serialize).forEach(arg_0 -> list.add(arg_0));
        tag.func_218657_a("__data", (INBT)list);
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        this.upgradeToLatestSchema(tag);
        if (tag.func_74762_e("__version") != 2) {
            throw new IllegalArgumentException("tag schema not latest after upgrading");
        }
        tag.func_150295_c("__data", 10).stream().map(c -> (CompoundNBT)c).map(FlowDataSerializer::deserialize).filter(Optional::isPresent).map(Optional::get).sorted(Comparator.comparing(a -> a instanceof RelationshipFlowData)).forEach(data -> data.addToDataContainer(this));
    }

    private void upgradeToLatestSchema(CompoundNBT tag) {
        int version = tag.func_74762_e("__version");
        if (version != 2) {
            SFM.LOGGER.debug(SFMUtil.getMarker(this.getClass()), "Updating schema from version {} to {}", (Object)version, (Object)2);
        }
        switch (version) {
            case 1: {
                tag.func_150295_c("__data", 10).stream().map(CompoundNBT.class::cast).forEach(t -> {
                    if (t.func_74764_b("factory_registry_name")) {
                        t.func_218657_a("__type", t.func_74781_a("factory_registry_name"));
                    }
                    if (t.func_74764_b("uuid")) {
                        t.func_218657_a("__uuid", t.func_74781_a("uuid"));
                    }
                    if (t.func_74764_b("version")) {
                        t.func_218657_a("__version", t.func_74781_a("version"));
                    }
                    if (t.func_74779_i("__type").equals("sfm:item_rule")) {
                        t.func_74778_a("__type", "sfm:item_movement_rule");
                    }
                });
                tag.func_74768_a("__version", 2);
            }
        }
    }

    public <T extends FlowData> Stream<T> get(Class<T> clazz) {
        return this.stream().filter(clazz::isInstance).map(clazz::cast);
    }

    public static class FlowDataContainerClosedClientEvent {
    }

    public static class FlowDataContainerChange {
        public final FlowData DATA;
        public final ChangeType CHANGE;

        public FlowDataContainerChange(FlowData data, ChangeType change) {
            this.DATA = data;
            this.CHANGE = change;
        }

        public static enum ChangeType {
            ADDED,
            REMOVED,
            UPDATED;

        }
    }
}

