/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.holder;

import ca.teamdman.sfm.common.flow.core.FlowDataHolder;
import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import java.util.Observable;
import java.util.Observer;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class FlowDataHolderObserver<T extends FlowData>
implements Observer {
    private final Class<T> CLAZZ;
    private final Predicate<T> CHECK;
    private final Consumer<T> ACTION;

    public FlowDataHolderObserver(Class<T> clazz, Predicate<T> check, Consumer<T> action) {
        this.CLAZZ = clazz;
        this.CHECK = check;
        this.ACTION = action;
    }

    public FlowDataHolderObserver(Class<T> clazz, FlowDataHolder<T> holder) {
        this(clazz, data -> ((FlowData)holder.getData()).getId().equals(data.getId()), holder::setData);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof BasicFlowDataContainer.FlowDataContainerChange) {
            FlowData data;
            BasicFlowDataContainer.FlowDataContainerChange change = (BasicFlowDataContainer.FlowDataContainerChange)arg;
            if (this.CLAZZ.isInstance(change.DATA) && this.CHECK.test(data = (FlowData)this.CLAZZ.cast(change.DATA))) {
                if (change.CHANGE == BasicFlowDataContainer.FlowDataContainerChange.ChangeType.REMOVED) {
                    o.deleteObserver(this);
                } else if (change.CHANGE == BasicFlowDataContainer.FlowDataContainerChange.ChangeType.UPDATED) {
                    this.ACTION.accept(data);
                }
            }
        } else if (arg instanceof BasicFlowDataContainer.FlowDataContainerClosedClientEvent) {
            o.deleteObserver(this);
        }
    }
}

