/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.flow.holder;

import ca.teamdman.sfm.common.flow.data.FlowData;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import java.util.Observable;
import java.util.Observer;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class FlowDataRemovedObserver
implements Observer {
    private final FlowData PARENT;
    private final Predicate<FlowData> PREDICATE;
    private final Consumer<BasicFlowDataContainer> ACTION;

    public FlowDataRemovedObserver(FlowData parent, Predicate<FlowData> predicate) {
        this(parent, predicate, c -> c.notifyChanged(parent));
    }

    public FlowDataRemovedObserver(FlowData parent, Predicate<FlowData> predicate, Consumer<BasicFlowDataContainer> action) {
        this.PARENT = parent;
        this.PREDICATE = predicate;
        this.ACTION = action;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof BasicFlowDataContainer.FlowDataContainerChange && o instanceof BasicFlowDataContainer) {
            BasicFlowDataContainer.FlowDataContainerChange change = (BasicFlowDataContainer.FlowDataContainerChange)arg;
            BasicFlowDataContainer container = (BasicFlowDataContainer)o;
            if (change.CHANGE == BasicFlowDataContainer.FlowDataContainerChange.ChangeType.REMOVED) {
                if (this.PREDICATE.test(change.DATA)) {
                    this.ACTION.accept(container);
                }
                if (change.DATA.getId().equals(this.PARENT.getId())) {
                    container.deleteObserver(this);
                }
            }
        }
    }
}

