/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net.packet.manager;

import ca.teamdman.sfm.common.container.ManagerContainer;
import ca.teamdman.sfm.common.net.packet.IContainerTilePacket;
import ca.teamdman.sfm.common.tile.manager.ManagerTileEntity;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class C2SManagerPacket
implements IContainerTilePacket {
    public final BlockPos TILE_POSITION;
    public final int WINDOW_ID;

    public C2SManagerPacket(int WINDOW_ID, BlockPos TILE_POSITION) {
        this.WINDOW_ID = WINDOW_ID;
        this.TILE_POSITION = TILE_POSITION;
    }

    @Override
    public BlockPos getTilePosition() {
        return this.TILE_POSITION;
    }

    @Override
    public int getWindowId() {
        return this.WINDOW_ID;
    }

    public static abstract class C2SHandler<MSG extends C2SManagerPacket> {
        public void encode(MSG msg, PacketBuffer buf) {
            buf.writeInt(((C2SManagerPacket)msg).WINDOW_ID);
            buf.func_179255_a(((C2SManagerPacket)msg).TILE_POSITION);
            this.finishEncode(msg, buf);
        }

        public abstract void finishEncode(MSG var1, PacketBuffer var2);

        public MSG decode(PacketBuffer buf) {
            return this.finishDecode(buf.readInt(), buf.func_179259_c(), buf);
        }

        public abstract MSG finishDecode(int var1, BlockPos var2, PacketBuffer var3);

        public void handle(MSG msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> SFMUtil.getTileFromContainerPacket(msg, ctx, ManagerContainer.class, ManagerTileEntity.class).ifPresent(manager -> this.handleDetailed(msg, (ManagerTileEntity)((Object)((Object)manager)))));
            ctx.get().setPacketHandled(true);
        }

        public abstract void handleDetailed(MSG var1, ManagerTileEntity var2);
    }
}

