/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net.packet.manager;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.gui.screen.ManagerScreen;
import ca.teamdman.sfm.common.net.packet.IWindowIdProvider;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class S2CManagerPacket
implements IWindowIdProvider {
    final int WINDOW_ID;

    public S2CManagerPacket(int WINDOW_ID) {
        this.WINDOW_ID = WINDOW_ID;
    }

    @Override
    public int getWindowId() {
        return this.WINDOW_ID;
    }

    public static abstract class S2CHandler<MSG extends S2CManagerPacket> {
        public void encode(MSG msg, PacketBuffer buf) {
            buf.writeInt(((S2CManagerPacket)msg).WINDOW_ID);
            this.finishEncode(msg, buf);
        }

        public abstract void finishEncode(MSG var1, PacketBuffer var2);

        public MSG decode(PacketBuffer buf) {
            return this.finishDecode(buf.readInt(), buf);
        }

        public abstract MSG finishDecode(int var1, PacketBuffer var2);

        public void handle(MSG msg, Supplier<NetworkEvent.Context> ctx) {
            SFM.PROXY.getScreenFromPacket((IWindowIdProvider)msg, ctx, ManagerScreen.class).ifPresent(screen -> this.handleDetailed((ManagerScreen)((Object)screen), msg));
            ctx.get().setPacketHandled(true);
        }

        public abstract void handleDetailed(ManagerScreen var1, MSG var2);
    }
}

