/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net.packet.manager.delete;

import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.net.packet.manager.C2SManagerPacket;
import ca.teamdman.sfm.common.net.packet.manager.delete.ManagerDeletePacketS2C;
import ca.teamdman.sfm.common.tile.manager.ManagerTileEntity;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class ManagerDeletePacketC2S
extends C2SManagerPacket {
    private final UUID ELEMENT_ID;

    public ManagerDeletePacketC2S(int windowId, BlockPos pos, UUID elementId) {
        super(windowId, pos);
        this.ELEMENT_ID = elementId;
    }

    public static class Handler
    extends C2SManagerPacket.C2SHandler<ManagerDeletePacketC2S> {
        @Override
        public void finishEncode(ManagerDeletePacketC2S msg, PacketBuffer buf) {
            SFMUtil.writeUUID(msg.ELEMENT_ID, buf);
        }

        @Override
        public ManagerDeletePacketC2S finishDecode(int windowId, BlockPos tilePos, PacketBuffer buf) {
            return new ManagerDeletePacketC2S(windowId, tilePos, SFMUtil.readUUID(buf));
        }

        @Override
        public void handleDetailed(ManagerDeletePacketC2S msg, ManagerTileEntity manager) {
            BasicFlowDataContainer container = manager.getFlowDataContainer();
            container.get(msg.ELEMENT_ID).ifPresent(data -> data.removeFromDataContainer(container));
            manager.markAndNotify();
            manager.sendPacketToListeners(windowId -> new ManagerDeletePacketS2C((int)windowId, msg.ELEMENT_ID));
        }
    }
}

