/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.tile;

import ca.teamdman.sfm.common.container.CrafterContainer;
import ca.teamdman.sfm.common.registrar.TileEntityRegistrar;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class CrafterTileEntity
extends TileEntity
implements ICapabilityProvider,
IRecipeHolder,
INamedContainerProvider {
    private final LazyOptional<ItemStackHandler> inventoryCapabilityExternal = LazyOptional.of(() -> this.inventory);
    private final LazyOptional<IItemHandlerModifiable> inventoryInputCapabilityExternal = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 10));
    private final LazyOptional<IItemHandlerModifiable> inventoryOutputCapabilityExternal = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 10, 11));
    private boolean debounce = false;
    public final ItemStackHandler inventory = new ItemStackHandler(10){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!CrafterTileEntity.this.debounce) {
                CrafterTileEntity.this.debounce = true;
                CrafterTileEntity.this.func_70296_d();
                if (slot == 9 && CrafterTileEntity.this.inventory.getStackInSlot(9) == ItemStack.field_190927_a) {
                    CrafterTileEntity.this.consumeIngredients(1);
                }
                CrafterTileEntity.this.onInputChanged();
                CrafterTileEntity.this.debounce = false;
            }
        }
    };
    private IRecipe<?> recipe;

    public CrafterTileEntity() {
        this(TileEntityRegistrar.Tiles.CRAFTER);
    }

    public CrafterTileEntity(TileEntityType<?> type) {
        super(type);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.inventoryCapabilityExternal.cast();
            }
            switch (side) {
                case DOWN: {
                    return this.inventoryOutputCapabilityExternal.cast();
                }
                case UP: 
                case NORTH: 
                case SOUTH: 
                case EAST: 
                case WEST: {
                    return this.inventoryInputCapabilityExternal.cast();
                }
            }
        }
        return super.getCapability(cap, side);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.inventory.deserializeNBT(nbt);
    }

    public CompoundNBT serializeNBT() {
        return this.inventory.serializeNBT();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.inventoryCapabilityExternal.invalidate();
        this.inventoryOutputCapabilityExternal.invalidate();
        this.inventoryInputCapabilityExternal.invalidate();
    }

    public void onCraftMatrixChanged() {
    }

    private void identifyRecipe(World world, PlayerEntity player, CraftingInventory inv, CraftResultInventory result) {
        if (world != null && !world.field_72995_K) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            ItemStack stack = serverPlayer.func_184102_h().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)inv, world).filter(r -> result.func_201561_a(world, serverPlayer, (IRecipe)r)).map(r -> r.func_77572_b((IInventory)inv)).orElse(ItemStack.field_190927_a);
            result.func_70299_a(0, stack);
        }
    }

    public void consumeIngredients(int amount) {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i).func_77946_l();
            stack.func_190920_e(stack.func_190916_E() - amount);
            this.inventory.setStackInSlot(i, stack);
        }
    }

    public void onInputChanged() {
        CraftingInventory guh = new CraftingInventory(new Container(ContainerType.field_221518_l, -1){

            public void func_75130_a(IInventory inventoryIn) {
            }

            public boolean func_75145_c(PlayerEntity playerIn) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            guh.func_70299_a(i, this.inventory.getStackInSlot(i));
        }
        List recipes = this.field_145850_b.func_199532_z().func_215370_b(IRecipeType.field_222149_a, (IInventory)guh, this.field_145850_b);
        if (recipes.size() > 0) {
            this.inventory.setStackInSlot(9, ((ICraftingRecipe)recipes.get(0)).func_77571_b().func_77946_l());
        } else {
            this.inventory.setStackInSlot(9, ItemStack.field_190927_a);
        }
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.sfm.crafter");
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInv, PlayerEntity player) {
        return new CrafterContainer(windowId, playerInv, this);
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        this.recipe = recipe;
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return this.recipe;
    }
}

