/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.tile.manager;

import ca.teamdman.sfm.common.flow.core.ItemMatcher;
import ca.teamdman.sfm.common.flow.data.ItemMovementRuleFlowData;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ExecutionState {
    private final Map<ItemMatcher, Integer> USAGE_HISTORY = new Object2IntOpenHashMap();

    public int getRemainingQuantity(ItemMovementRuleFlowData rule, @Nullable ItemMatcher matcher) {
        if (rule.filterMode == ItemMovementRuleFlowData.FilterMode.WHITELIST) {
            if (matcher == null) {
                return 0;
            }
            int maxAllowed = matcher.getQuantity();
            int used = this.USAGE_HISTORY.getOrDefault(matcher, 0);
            return Math.max(0, maxAllowed - used);
        }
        if (rule.filterMode == ItemMovementRuleFlowData.FilterMode.BLACKLIST) {
            return matcher == null ? Integer.MAX_VALUE : 0;
        }
        return 0;
    }

    public void recordUsage(@Nullable ItemMatcher matcher, int amount) {
        if (matcher != null) {
            this.USAGE_HISTORY.merge(matcher, amount, Integer::sum);
        }
    }
}

