/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.tile.manager;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.container.ManagerContainer;
import ca.teamdman.sfm.common.flow.data.CursorFlowData;
import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.net.PacketHandler;
import ca.teamdman.sfm.common.registrar.TileEntityRegistrar;
import ca.teamdman.sfm.common.tile.manager.FlowExecutor;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;

public class ManagerTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private final BasicFlowDataContainer FLOW_DATA_CONTAINER = new BasicFlowDataContainer();
    private final FlowExecutor EXECUTOR;
    private final int NBT_SCHEMA_VERSION = 2;
    private final String NBT_SCHEMA_VERSION_KEY = "__version";
    private final String NBT_SCHEMA_DATA_KEY = "__data";
    private final Map<ServerPlayerEntity, Integer> CONTAINER_LISTENERS = new WeakHashMap<ServerPlayerEntity, Integer>();

    public ManagerTileEntity() {
        this(TileEntityRegistrar.Tiles.MANAGER);
    }

    public ManagerTileEntity(TileEntityType<?> type) {
        super(type);
        this.EXECUTOR = new FlowExecutor(this);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInv, PlayerEntity player) {
        ManagerContainer managerContainer = new ManagerContainer(windowId, this, false);
        return managerContainer;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.sfm.manager");
    }

    public void addContainerListener(ServerPlayerEntity player, int windowId) {
        this.CONTAINER_LISTENERS.put(player, windowId);
        this.pruneCursors();
    }

    public void pruneCursors() {
        Set listeners = this.getContainerListeners().map(Map.Entry::getKey).map(Entity::func_110124_au).collect(Collectors.toSet());
        this.getFlowDataContainer().removeIf(data -> data instanceof CursorFlowData && !listeners.contains(data.getId()));
    }

    public Stream<Map.Entry<ServerPlayerEntity, Integer>> getContainerListeners() {
        return new ArrayList<Map.Entry<ServerPlayerEntity, Integer>>(this.CONTAINER_LISTENERS.entrySet()).stream();
    }

    public BasicFlowDataContainer getFlowDataContainer() {
        return this.FLOW_DATA_CONTAINER;
    }

    public void removeContainerListener(ServerPlayerEntity player) {
        this.CONTAINER_LISTENERS.remove(player);
        this.pruneCursors();
    }

    public void markAndNotify() {
        if (this.func_145831_w() == null) {
            return;
        }
        this.func_70296_d();
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 0);
    }

    public <MSG> void sendPacketToListeners(Function<Integer, MSG> packetFunc) {
        this.getContainerListeners().forEach(entry -> {
            ServerPlayerEntity player = (ServerPlayerEntity)entry.getKey();
            Object packet = packetFunc.apply((Integer)entry.getValue());
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), packet);
        });
    }

    public void closeGuiForAllListeners() {
        this.getContainerListeners().map(Map.Entry::getKey).forEach(ServerPlayerEntity::func_71053_j);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_150297_b("data", 10)) {
            this.deserializeNBT(tag.func_74775_l("data"));
        }
    }

    public void deserializeNBT(CompoundNBT tag) {
        SFM.LOGGER.debug(SFMUtil.getMarker(((Object)((Object)this)).getClass()), "Loading nbt on {}, replacing {} entries", (Object)(this.field_145850_b == null ? "null world" : (this.field_145850_b.field_72995_K ? "client" : "server")), (Object)this.getFlowDataContainer().size());
        this.upgradeSavedData(tag);
        if (tag.func_74762_e("__version") != 2) {
            throw new IllegalArgumentException("tag not using latest schema after upgrade");
        }
        this.getFlowDataContainer().clear();
        this.getFlowDataContainer().deserializeNBT(tag.func_74775_l("__data"));
    }

    private void upgradeSavedData(CompoundNBT tag) {
        int version;
        if (tag.func_150297_b("version", 3)) {
            tag.func_74768_a("__version", tag.func_74762_e("version"));
            tag.func_82580_o("version");
        }
        if ((version = tag.func_74762_e("__version")) != 2) {
            SFM.LOGGER.debug(SFMUtil.getMarker(((Object)((Object)this)).getClass()), "Updating schema from version {} to {}", (Object)version, (Object)2);
        }
        switch (version) {
            case 1: {
                ListNBT data = tag.func_150295_c("flow_data_list", 10);
                tag.func_82580_o("flow_data_list");
                CompoundNBT dataHolder = new CompoundNBT();
                dataHolder.func_74768_a("__version", 1);
                dataHolder.func_218657_a("__data", (INBT)data);
                tag.func_218657_a("__data", (INBT)dataHolder);
                tag.func_74768_a("__version", 2);
            }
        }
    }

    public CompoundNBT serializeNBT() {
        this.pruneCursors();
        SFM.LOGGER.debug(SFMUtil.getMarker(((Object)((Object)this)).getClass()), "Saving NBT on {}, writing {} entries", (Object)(this.field_145850_b == null ? "null world" : (this.field_145850_b.field_72995_K ? "client" : "server")), (Object)this.getFlowDataContainer().size());
        CompoundNBT c = new CompoundNBT();
        c.func_74768_a("__version", 2);
        c.func_218657_a("__data", (INBT)this.getFlowDataContainer().serializeNBT());
        return c;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("data", (INBT)this.serializeNBT());
        return compound;
    }

    public void func_73660_a() {
        this.EXECUTOR.tick();
    }
}

