/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;

public class EnumSetSerializationHelper {
    public static ListNBT serialize(EnumSet<?> set) {
        return set.stream().map(Enum::name).map(StringNBT::func_229705_a_).collect(ListNBT::new, AbstractList::add, AbstractCollection::addAll);
    }

    public static <T extends Enum<T>> EnumSet<T> deserialize(CompoundNBT tag, String key, Function<String, T> resolver) {
        return EnumSet.copyOf(tag.func_150295_c(key, 8).stream().map(INBT::func_150285_a_).map(resolver).collect(Collectors.toList()));
    }

    public static void serialize(EnumSet<?> set, PacketBuffer buf) {
        buf.writeInt(set.size());
        set.stream().map(Enum::name).forEach(name -> buf.func_211400_a(name, 128));
    }

    public static <T extends Enum<T>> EnumSet<T> deserialize(PacketBuffer buf, Function<String, T> resolver, Class<T> type) {
        List vals = IntStream.range(0, buf.readInt()).mapToObj(__ -> buf.func_150789_c(128)).map(resolver).collect(Collectors.toList());
        if (vals.isEmpty()) {
            return EnumSet.noneOf(type);
        }
        return EnumSet.copyOf(vals);
    }
}

