/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import ca.teamdman.sfm.common.net.packet.IContainerTilePacket;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class SFMUtil {
    public static final int UUID_STRING_LENGTH = 36;

    public static void writeUUID(UUID id, PacketBuffer buf) {
        buf.func_211400_a(id.toString(), 36);
    }

    public static Marker getMarker(Class clazz) {
        String[] x = clazz.getName().split("\\.");
        return MarkerManager.getMarker((String)x[x.length - 1]);
    }

    public static <T extends TileEntity> Optional<T> getServerTile(IWorldPosCallable access, Class<T> clazz) {
        return (Optional)access.func_221485_a((world, pos) -> SFMUtil.getTile((IWorldReader)world, pos, clazz, false), Optional.empty());
    }

    public static <T extends TileEntity> Optional<T> getTile(IWorldReader world, BlockPos pos, Class<T> clazz, boolean remote) {
        if (world.func_201670_d() != remote) {
            return Optional.empty();
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return Optional.empty();
        }
        if (clazz.isInstance(tile)) {
            return Optional.of(tile);
        }
        return Optional.empty();
    }

    public static <T extends TileEntity> Optional<T> getClientTile(IWorldPosCallable access, Class<T> clazz) {
        return (Optional)access.func_221485_a((world, pos) -> SFMUtil.getTile((IWorldReader)world, pos, clazz, true), Optional.empty());
    }

    public static <T extends TileEntity> Optional<T> getTileFromContainerPacket(IContainerTilePacket packet, Supplier<NetworkEvent.Context> ctx, Class<? extends Container> containerClass, Class<T> tileClass) {
        if (ctx == null) {
            return Optional.empty();
        }
        NetworkEvent.Context context = ctx.get();
        if (context == null) {
            return Optional.empty();
        }
        ServerPlayerEntity sender = context.getSender();
        if (sender == null) {
            return Optional.empty();
        }
        if (!containerClass.isInstance(sender.field_71070_bA)) {
            return Optional.empty();
        }
        if (sender.field_71070_bA.field_75152_c != packet.getWindowId()) {
            return Optional.empty();
        }
        ServerWorld world = sender.func_71121_q();
        if (!world.func_175667_e(packet.getTilePosition())) {
            return Optional.empty();
        }
        TileEntity tile = world.func_175625_s(packet.getTilePosition());
        if (!tileClass.isInstance(tile)) {
            return Optional.empty();
        }
        return Optional.of(tile);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isKeyDown(int key) {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)key);
    }

    public static <T> Stream<T> getRecursiveStream(RecursiveBuilder<T> operator, T first) {
        Stream.Builder builder = Stream.builder();
        HashSet debounce = new HashSet();
        ArrayDeque toVisit = new ArrayDeque();
        toVisit.add(first);
        debounce.add(first);
        while (toVisit.size() > 0) {
            Object current = toVisit.pop();
            operator.accept(current, next -> {
                if (!debounce.contains(next)) {
                    debounce.add(next);
                    toVisit.add(next);
                }
            }, builder::add);
        }
        return builder.build();
    }

    public static double getDistanceFromLine(int x, int y, int x1, int y1, int x2, int y2) {
        double yy;
        double xx;
        int A = x - x1;
        int B = y - y1;
        int C = x2 - x1;
        int D = y2 - y1;
        int dot = A * C + B * D;
        int len_sq = C * C + D * D;
        double param = -1.0;
        if (len_sq != 0) {
            param = (double)dot / (double)len_sq;
        }
        if (param < 0.0) {
            xx = x1;
            yy = y1;
        } else if (param > 1.0) {
            xx = x2;
            yy = y2;
        } else {
            xx = (double)x1 + param * (double)C;
            yy = (double)y1 + param * (double)D;
        }
        double dx = (double)x - xx;
        double dy = (double)y - yy;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static UUID readUUID(PacketBuffer buf) {
        return UUID.fromString(buf.func_150789_c(36));
    }

    public static interface RecursiveBuilder<T> {
        public void accept(T var1, Consumer<T> var2, Consumer<T> var3);
    }
}

