/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class SlotsRule {
    private static final Pattern RANGE = Pattern.compile("(?<start>\\d+)\\s*-\\s*(?<end>\\d+)");
    private static final Pattern LOWER_BOUND = Pattern.compile("(?<start>\\d+)\\s*\\+");
    private static final Pattern CONST = Pattern.compile("(?<num>\\d+)");
    private String definition;

    public SlotsRule(String definition) {
        this.setDefinition(definition);
    }

    public SlotsRule(SlotsRule other) {
        this(other.definition);
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition.replaceAll("[^\\d, \\-+]", "");
    }

    public SlotsRule copy() {
        return new SlotsRule(this);
    }

    public boolean isValidDefinition(String definition) {
        return definition.matches("[\\d, \\-+]*");
    }

    public IntStream getSlots(int maxSlot) {
        if (this.definition.length() == 0) {
            return IntStream.range(0, maxSlot);
        }
        return Arrays.stream(this.definition.split(",")).flatMapToInt(rule -> this.evaluateRule((String)rule, maxSlot)).distinct();
    }

    public IntStream evaluateRule(String rule, int maxSlot) {
        try {
            Matcher matcher = RANGE.matcher(rule);
            if (matcher.matches()) {
                int lowerBound = Integer.parseInt(matcher.group("start"));
                int upperBound = Integer.parseInt(matcher.group("end"));
                return IntStream.range(lowerBound, upperBound);
            }
            matcher = LOWER_BOUND.matcher(rule);
            if (matcher.matches()) {
                int lowerBound = Integer.parseInt(matcher.group("start"));
                return IntStream.range(lowerBound, maxSlot);
            }
            matcher = CONST.matcher(rule);
            if (matcher.matches()) {
                int num = Integer.parseInt(matcher.group("num"));
                return IntStream.of(num);
            }
        }
        catch (NumberFormatException e) {
            return IntStream.empty();
        }
        return IntStream.empty();
    }
}

