/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import ca.teamdman.sfm.common.flow.holder.BasicFlowDataContainer;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;

public class UUIDList
extends ArrayList<UUID> {
    public UUIDList(Collection<? extends UUID> c) {
        super(c);
    }

    public UUIDList(PacketBuffer buf) {
        IntStream.range(0, buf.readInt()).mapToObj(__ -> SFMUtil.readUUID(buf)).forEach(this::add);
    }

    public UUIDList(CompoundNBT tag, String key) {
        tag.func_150295_c(key, 8).stream().map(INBT::func_150285_a_).map(UUID::fromString).forEach(this::add);
    }

    public ListNBT serialize() {
        return this.stream().map(UUID::toString).map(StringNBT::func_229705_a_).collect(ListNBT::new, AbstractList::add, AbstractCollection::addAll);
    }

    public void serialize(PacketBuffer buf) {
        buf.writeInt(this.size());
        this.forEach((? super E id) -> SFMUtil.writeUUID(id, buf));
    }

    public <T> Stream<T> lookup(BasicFlowDataContainer container, Class<T> type) {
        return this.stream().map(id -> container.get((UUID)id, type)).filter(Optional::isPresent).map(Optional::get);
    }
}

