/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.blockentity;

import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.menu.ManagerMenu;
import ca.teamdman.sfm.common.program.ProgramExecutor;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.util.SFMContainerUtil;
import ca.teamdman.sfml.SFMLLexer;
import ca.teamdman.sfml.SFMLParser;
import ca.teamdman.sfml.ast.ASTBuilder;
import ca.teamdman.sfml.ast.Program;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class ManagerBlockEntity
extends BaseContainerBlockEntity {
    public static final int STATE_DATA_ACCESS_KEY = 0;
    private final NonNullList<ItemStack> ITEMS = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private ProgramExecutor compiledProgram = null;
    private final ContainerData DATA_ACCESS = new ContainerData(){

        public int m_6413_(int key) {
            return switch (key) {
                case 0 -> ManagerBlockEntity.this.getState().ordinal();
                default -> 0;
            };
        }

        public void m_8050_(int key, int val) {
        }

        public int m_6499_() {
            return 1;
        }
    };

    public ManagerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)SFMBlockEntities.MANAGER_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ManagerBlockEntity tile) {
        if (tile.compiledProgram != null) {
            tile.compiledProgram.tick();
        }
    }

    public State getState() {
        if (this.getDisk().isEmpty()) {
            return State.NO_DISK;
        }
        if (this.getProgram().isEmpty()) {
            return State.NO_PROGRAM;
        }
        if (this.compiledProgram == null) {
            return State.INVALID_PROGRAM;
        }
        return State.RUNNING;
    }

    public Optional<String> getProgram() {
        return this.getDisk().map(DiskItem::getProgram).filter(prog -> !prog.isBlank());
    }

    public Set<String> getReferencedLabels() {
        if (this.compiledProgram == null) {
            return Collections.emptySet();
        }
        return this.compiledProgram.getReferencedLabels();
    }

    public void setProgram(String program) {
        this.getDisk().ifPresent(disk -> {
            DiskItem.setProgram(disk, program);
            this.compileProgram();
            this.m_6596_();
        });
    }

    public Optional<ItemStack> getDisk() {
        ItemStack item = this.m_8020_(0);
        if (item.m_41720_() instanceof DiskItem) {
            return Optional.of(item);
        }
        return Optional.empty();
    }

    private void compileProgram() {
        this.compiledProgram = null;
        if (this.getProgram().isEmpty()) {
            return;
        }
        ItemStack disk = this.getDisk().get();
        String program = this.getProgram().get();
        SFMLLexer lexer = new SFMLLexer((CharStream)CharStreams.fromString((String)program));
        lexer.removeErrorListeners();
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        SFMLParser parser = new SFMLParser((TokenStream)tokens);
        parser.removeErrorListeners();
        final ArrayList<String> errors = new ArrayList<String>();
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                errors.add("line " + line + ":" + charPositionInLine + " " + msg);
            }
        });
        SFMLParser.ProgramContext context = parser.program();
        Program programAST = null;
        try {
            programAST = new ASTBuilder().visitProgram(context);
            DiskItem.setProgramName(disk, programAST.name());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (parser.getNumberOfSyntaxErrors() == 0) {
            this.compiledProgram = new ProgramExecutor(programAST, this);
        }
        DiskItem.setErrors(disk, errors);
    }

    protected Component m_6820_() {
        return new TranslatableComponent("container.sfm.manager");
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory inv) {
        return new ManagerMenu(windowId, inv, (Container)this, this.m_58899_(), this.DATA_ACCESS, this.getProgram().orElse(""));
    }

    public int m_6643_() {
        return this.ITEMS.size();
    }

    public boolean m_7983_() {
        return this.ITEMS.isEmpty();
    }

    public ItemStack m_8020_(int slot) {
        if (slot < 0 || slot >= this.ITEMS.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.ITEMS.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack result = ContainerHelper.m_18969_(this.ITEMS, (int)slot, (int)amount);
        if (slot == 0) {
            this.compileProgram();
        }
        this.m_6596_();
        return result;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack result = ContainerHelper.m_18966_(this.ITEMS, (int)slot);
        if (slot == 0) {
            this.compileProgram();
        }
        this.m_6596_();
        return result;
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.ITEMS.size()) {
            return;
        }
        this.ITEMS.set(slot, (Object)stack);
        if (slot == 0) {
            this.compileProgram();
        }
        this.m_6596_();
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return stack.m_41720_() instanceof DiskItem;
    }

    public boolean m_6542_(Player player) {
        return SFMContainerUtil.stillValid((BlockEntity)this, player);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.ITEMS);
        this.compileProgram();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.ITEMS);
    }

    public void m_6211_() {
        this.ITEMS.clear();
    }

    public void reset() {
        this.getDisk().ifPresent(disk -> {
            disk.m_41751_(null);
            this.m_6836_(0, (ItemStack)disk);
            this.m_6596_();
        });
    }

    public static enum State {
        NO_PROGRAM(ChatFormatting.RED),
        NO_DISK(ChatFormatting.RED),
        RUNNING(ChatFormatting.GREEN),
        INVALID_PROGRAM(ChatFormatting.DARK_RED);

        public final ChatFormatting COLOR;

        private State(ChatFormatting color) {
            this.COLOR = color;
        }
    }
}

