/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.util.SFMUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CableNetworkManager {
    private static final Multimap<ResourceKey<Level>, CableNetwork> NETWORKS = ArrayListMultimap.create();

    public static void printDebugInfo() {
        SFM.LOGGER.info(SFMUtil.getMarker(CableNetworkManager.class), "{} networks now", (Object)CableNetworkManager.size());
    }

    public static int size() {
        return NETWORKS.size();
    }

    public static void unregister(Level level, BlockPos cablePos) {
        CableNetworkManager.getNetwork(level, cablePos).ifPresent(network -> {
            Set<CableNetwork> branches = network.remove(cablePos);
            CableNetworkManager.removeNetwork(network);
            branches.forEach(CableNetworkManager::addNetwork);
        });
    }

    public static Optional<CableNetwork> getOrRegisterNetwork(BlockEntity tile) {
        return CableNetworkManager.getOrRegisterNetwork(tile.m_58904_(), tile.m_58899_());
    }

    private static Optional<CableNetwork> getNetwork(Level level, BlockPos pos) {
        return NETWORKS.get((Object)level.m_46472_()).stream().filter(net -> net.getLevel().m_5776_() == level.m_5776_()).filter(net -> net.contains(pos)).findFirst();
    }

    private static boolean removeNetwork(CableNetwork network) {
        return NETWORKS.remove((Object)network.getLevel().m_46472_(), (Object)network);
    }

    private static boolean addNetwork(CableNetwork network) {
        return NETWORKS.put((Object)network.getLevel().m_46472_(), (Object)network);
    }

    private static Set<CableNetwork> getCandidateNetworks(Level level, BlockPos pos) {
        return NETWORKS.get((Object)level.m_46472_()).stream().filter(net -> net.getLevel().m_5776_() == level.f_46443_).filter(net -> net.hasCableNeighbour(pos)).collect(Collectors.toSet());
    }

    private static Optional<CableNetwork> createAndRegisterNetwork(Level level, BlockPos origin) {
        CableNetwork network = new CableNetwork(level);
        CableNetworkManager.addNetwork(network);
        network.rebuildNetwork(origin);
        return Optional.of(network);
    }

    private static Optional<CableNetwork> mergeNetworks(Set<CableNetwork> networks) {
        if (networks.isEmpty()) {
            return Optional.empty();
        }
        Iterator<CableNetwork> iterator = networks.iterator();
        CableNetwork main = iterator.next();
        iterator.forEachRemaining(other -> {
            main.mergeNetwork((CableNetwork)other);
            CableNetworkManager.removeNetwork(other);
        });
        return Optional.of(main);
    }

    public static Optional<CableNetwork> getOrRegisterNetwork(Level level, BlockPos pos) {
        if (!CableNetwork.isValidNetworkMember(level, pos)) {
            return Optional.empty();
        }
        Optional<CableNetwork> existing = CableNetworkManager.getNetwork(level, pos);
        if (existing.isPresent()) {
            return existing;
        }
        Set<CableNetwork> candidates = CableNetworkManager.getCandidateNetworks(level, pos);
        if (candidates.isEmpty()) {
            return CableNetworkManager.createAndRegisterNetwork(level, pos);
        }
        if (candidates.size() == 1) {
            CableNetwork network = candidates.iterator().next();
            network.addCable(pos);
            return Optional.of(network);
        }
        Optional<CableNetwork> result = CableNetworkManager.mergeNetworks(candidates);
        result.ifPresent(net -> net.addCable(pos));
        return result;
    }
}

