/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfml.SFMLBaseVisitor;
import ca.teamdman.sfml.SFMLParser;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Block;
import ca.teamdman.sfml.ast.BoolExpr;
import ca.teamdman.sfml.ast.ComparisonOperator;
import ca.teamdman.sfml.ast.DirectionQualifier;
import ca.teamdman.sfml.ast.IfStatement;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Interval;
import ca.teamdman.sfml.ast.ItemComparer;
import ca.teamdman.sfml.ast.ItemIdentifier;
import ca.teamdman.sfml.ast.ItemLimit;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.Matchers;
import ca.teamdman.sfml.ast.NumberRange;
import ca.teamdman.sfml.ast.NumberRangeSet;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.ast.Quantity;
import ca.teamdman.sfml.ast.SetOperator;
import ca.teamdman.sfml.ast.Side;
import ca.teamdman.sfml.ast.Statement;
import ca.teamdman.sfml.ast.StringHolder;
import ca.teamdman.sfml.ast.TimerTrigger;
import ca.teamdman.sfml.ast.Trigger;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.tree.ParseTree;

public class ASTBuilder
extends SFMLBaseVisitor<ASTNode> {
    private final Set<Label> LABELS = new HashSet<Label>();

    private void trackLabel(Label label) {
        this.LABELS.add(label);
    }

    public Set<Label> getLabels() {
        return this.LABELS;
    }

    @Override
    public StringHolder visitName(SFMLParser.NameContext ctx) {
        if (ctx == null) {
            return new StringHolder("");
        }
        return this.visitString(ctx.string());
    }

    @Override
    public ItemIdentifier visitItem(SFMLParser.ItemContext ctx) {
        List params = ctx.IDENTIFIER().stream().map(ParseTree::getText).collect(Collectors.toList());
        if (params.size() == 1) {
            return new ItemIdentifier((String)params.get(0));
        }
        return new ItemIdentifier((String)params.get(0), (String)params.get(1));
    }

    @Override
    public StringHolder visitString(SFMLParser.StringContext ctx) {
        String content = ctx.getText();
        return new StringHolder(content.substring(1, content.length() - 1));
    }

    @Override
    public Label visitLabel(SFMLParser.LabelContext ctx) {
        Label label = new Label(ctx.getText());
        this.trackLabel(label);
        return label;
    }

    @Override
    public Program visitProgram(SFMLParser.ProgramContext ctx) {
        StringHolder name = this.visitName(ctx.name());
        List<Trigger> triggers = ctx.trigger().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(Trigger.class::cast).collect(Collectors.toList());
        Set<String> labels = this.getLabels().stream().map(Label::name).collect(Collectors.toSet());
        return new Program(name.value(), triggers, labels);
    }

    @Override
    public ASTNode visitTimerTrigger(SFMLParser.TimerTriggerContext ctx) {
        Interval time = (Interval)this.visit((ParseTree)ctx.interval());
        if (time.getSeconds() < 1) {
            throw new IllegalArgumentException("Minimum trigger interval is 1 second.");
        }
        Block block = this.visitBlock(ctx.block());
        return new TimerTrigger(time, block);
    }

    @Override
    public Quantity visitNumber(SFMLParser.NumberContext ctx) {
        return new Quantity(Integer.parseInt(ctx.getText()));
    }

    @Override
    public Interval visitTicks(SFMLParser.TicksContext ctx) {
        Quantity num = this.visitNumber(ctx.number());
        return Interval.fromTicks(num.value());
    }

    @Override
    public Interval visitSeconds(SFMLParser.SecondsContext ctx) {
        Quantity num = this.visitNumber(ctx.number());
        return Interval.fromSeconds(num.value());
    }

    @Override
    public InputStatement visitInputStatementStatement(SFMLParser.InputStatementStatementContext ctx) {
        return (InputStatement)this.visit((ParseTree)ctx.inputstatement());
    }

    @Override
    public OutputStatement visitOutputStatementStatement(SFMLParser.OutputStatementStatementContext ctx) {
        return (OutputStatement)this.visit((ParseTree)ctx.outputstatement());
    }

    @Override
    public InputStatement visitInputstatement(SFMLParser.InputstatementContext ctx) {
        LabelAccess labelAccess = this.visitLabelaccess(ctx.labelaccess());
        Matchers matchers = this.visitInputmatchers(ctx.inputmatchers());
        boolean each = ctx.EACH() != null;
        return new InputStatement(labelAccess, matchers, each);
    }

    @Override
    public OutputStatement visitOutputstatement(SFMLParser.OutputstatementContext ctx) {
        LabelAccess labelAccess = this.visitLabelaccess(ctx.labelaccess());
        Matchers matchers = this.visitOutputmatchers(ctx.outputmatchers());
        boolean each = ctx.EACH() != null;
        return new OutputStatement(labelAccess, matchers, each);
    }

    @Override
    public LabelAccess visitLabelaccess(SFMLParser.LabelaccessContext ctx) {
        return new LabelAccess(ctx.label().stream().map(this::visitLabel).collect(Collectors.toList()), this.visitSidequalifier(ctx.sidequalifier()), this.visitSlotqualifier(ctx.slotqualifier()));
    }

    @Override
    public IfStatement visitIfstatement(SFMLParser.IfstatementContext ctx) {
        List<BoolExpr> expressions = ctx.boolexpr().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(BoolExpr.class::cast).collect(Collectors.toList());
        List<Block> blocks = ctx.block().stream().map(this::visitBlock).collect(Collectors.toList());
        return new IfStatement(expressions, blocks);
    }

    @Override
    public IfStatement visitIfStatementStatement(SFMLParser.IfStatementStatementContext ctx) {
        return this.visitIfstatement(ctx.ifstatement());
    }

    @Override
    public BoolExpr visitBooleanTrue(SFMLParser.BooleanTrueContext ctx) {
        return new BoolExpr(__ -> true);
    }

    @Override
    public BoolExpr visitBooleanHas(SFMLParser.BooleanHasContext ctx) {
        SetOperator setOp = this.visitSetOp(ctx.setOp());
        LabelAccess labelAccess = this.visitLabelaccess(ctx.labelaccess());
        ItemComparer itemComparison = this.visitItemcomparison(ctx.itemcomparison());
        return ItemComparer.toBooleanExpression(setOp, labelAccess, itemComparison);
    }

    @Override
    public SetOperator visitSetOp(SFMLParser.SetOpContext ctx) {
        if (ctx == null) {
            return SetOperator.OVERALL;
        }
        return SetOperator.from(ctx.getText());
    }

    @Override
    public ItemComparer visitItemcomparison(SFMLParser.ItemcomparisonContext ctx) {
        ComparisonOperator op = this.visitComparisonOp(ctx.comparisonOp());
        Quantity num = this.visitNumber(ctx.number());
        ItemIdentifier item = this.visitItem(ctx.item());
        return new ItemComparer(op, num, item);
    }

    @Override
    public ComparisonOperator visitComparisonOp(SFMLParser.ComparisonOpContext ctx) {
        return ComparisonOperator.from(ctx.getText());
    }

    @Override
    public BoolExpr visitBooleanConjunction(SFMLParser.BooleanConjunctionContext ctx) {
        BoolExpr left = (BoolExpr)this.visit((ParseTree)ctx.boolexpr(0));
        BoolExpr right = (BoolExpr)this.visit((ParseTree)ctx.boolexpr(1));
        return new BoolExpr(left.and(right));
    }

    @Override
    public BoolExpr visitBooleanDisjunction(SFMLParser.BooleanDisjunctionContext ctx) {
        BoolExpr left = (BoolExpr)this.visit((ParseTree)ctx.boolexpr(0));
        BoolExpr right = (BoolExpr)this.visit((ParseTree)ctx.boolexpr(1));
        return new BoolExpr(left.or(right));
    }

    @Override
    public BoolExpr visitBooleanFalse(SFMLParser.BooleanFalseContext ctx) {
        return new BoolExpr(__ -> false);
    }

    @Override
    public BoolExpr visitBooleanParen(SFMLParser.BooleanParenContext ctx) {
        return (BoolExpr)this.visit((ParseTree)ctx.boolexpr());
    }

    @Override
    public BoolExpr visitBooleanNegation(SFMLParser.BooleanNegationContext ctx) {
        BoolExpr x = (BoolExpr)this.visit((ParseTree)ctx.boolexpr());
        return new BoolExpr(x.negate());
    }

    @Override
    public Limit visitQuantityRetentionLimit(SFMLParser.QuantityRetentionLimitContext ctx) {
        Quantity quantity = this.visitQuantity(ctx.quantity());
        Quantity retain = this.visitRetention(ctx.retention());
        return new Limit(quantity.value(), retain.value());
    }

    @Override
    public Matchers visitInputmatchers(SFMLParser.InputmatchersContext ctx) {
        if (ctx == null) {
            return new Matchers(List.of(new ItemLimit(new Limit(Integer.MAX_VALUE, 0))));
        }
        return ((Matchers)this.visit((ParseTree)ctx.itemmovement())).withDefaults(Integer.MAX_VALUE, 0);
    }

    @Override
    public Matchers visitOutputmatchers(SFMLParser.OutputmatchersContext ctx) {
        if (ctx == null) {
            return new Matchers(List.of(new ItemLimit(new Limit(Integer.MAX_VALUE, Integer.MAX_VALUE))));
        }
        return ((Matchers)this.visit((ParseTree)ctx.itemmovement())).withDefaults(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public Matchers visitItemLimitMovement(SFMLParser.ItemLimitMovementContext ctx) {
        return new Matchers(ctx.itemlimit().stream().map(this::visitItemlimit).collect(Collectors.toList()));
    }

    @Override
    public Matchers visitLimitMovement(SFMLParser.LimitMovementContext ctx) {
        return new Matchers(List.of(new ItemLimit((Limit)this.visit((ParseTree)ctx.limit()))));
    }

    @Override
    public ItemLimit visitItemlimit(SFMLParser.ItemlimitContext ctx) {
        ItemIdentifier item = this.visitItem(ctx.item());
        if (ctx.limit() == null) {
            return new ItemLimit(item);
        }
        Limit limit = (Limit)this.visit((ParseTree)ctx.limit());
        return new ItemLimit(limit, item);
    }

    @Override
    public NumberRangeSet visitSlotqualifier(SFMLParser.SlotqualifierContext ctx) {
        return this.visitRangeset(ctx == null ? null : ctx.rangeset());
    }

    @Override
    public NumberRangeSet visitRangeset(SFMLParser.RangesetContext ctx) {
        if (ctx == null) {
            return new NumberRangeSet(List.of(new NumberRange(Integer.MIN_VALUE, Integer.MAX_VALUE)));
        }
        return new NumberRangeSet(ctx.range().stream().map(this::visitRange).collect(Collectors.toList()));
    }

    @Override
    public NumberRange visitRange(SFMLParser.RangeContext ctx) {
        PrimitiveIterator.OfInt iter = ctx.number().stream().map(this::visitNumber).mapToInt(Quantity::value).iterator();
        Integer start = iter.next();
        if (iter.hasNext()) {
            Integer end = iter.next();
            return new NumberRange(start, end);
        }
        return new NumberRange(start, start);
    }

    @Override
    public Limit visitRetentionLimit(SFMLParser.RetentionLimitContext ctx) {
        Quantity retain = this.visitRetention(ctx.retention());
        return new Limit(-1, retain.value());
    }

    @Override
    public Limit visitQuantityLimit(SFMLParser.QuantityLimitContext ctx) {
        Quantity quantity = this.visitQuantity(ctx.quantity());
        return new Limit(quantity.value(), -1);
    }

    @Override
    public Quantity visitRetention(SFMLParser.RetentionContext ctx) {
        if (ctx == null) {
            return new Quantity(-1);
        }
        return this.visitNumber(ctx.number());
    }

    @Override
    public Quantity visitQuantity(SFMLParser.QuantityContext ctx) {
        if (ctx == null) {
            return new Quantity(Integer.MAX_VALUE);
        }
        return this.visitNumber(ctx.number());
    }

    @Override
    public DirectionQualifier visitSidequalifier(SFMLParser.SidequalifierContext ctx) {
        if (ctx == null) {
            return new DirectionQualifier(Stream.empty());
        }
        Stream<Side> sides = ctx.side().stream().map(this::visitSide);
        return new DirectionQualifier(sides);
    }

    @Override
    public Side visitSide(SFMLParser.SideContext ctx) {
        return Side.valueOf(ctx.getText().toUpperCase(Locale.ROOT));
    }

    @Override
    public Block visitBlock(SFMLParser.BlockContext ctx) {
        if (ctx == null) {
            return new Block(Collections.emptyList());
        }
        List<Statement> statements = ctx.statement().stream().map(arg_0 -> ((ASTBuilder)this).visit(arg_0)).map(Statement.class::cast).collect(Collectors.toList());
        return new Block(statements);
    }
}

