/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public abstract class MenuPacket {
    public final BlockPos POSITION;
    public final int CONTAINER_ID;

    public MenuPacket(int containerId, BlockPos pos) {
        this.POSITION = pos;
        this.CONTAINER_ID = containerId;
    }

    public static abstract class MenuPacketHandler<MENU extends AbstractContainerMenu, BLOCK_ENTITY extends BaseContainerBlockEntity, MSG extends MenuPacket> {
        private final Class<MENU> MENU_CLASS;
        private final Class<BLOCK_ENTITY> BLOCK_ENTITY_CLASS;

        protected MenuPacketHandler(Class<MENU> menuClass, Class<BLOCK_ENTITY> blockEntityClass) {
            this.MENU_CLASS = menuClass;
            this.BLOCK_ENTITY_CLASS = blockEntityClass;
        }

        public final void _encode(MSG msg, FriendlyByteBuf buf) {
            buf.writeInt(((MenuPacket)msg).CONTAINER_ID);
            buf.m_130064_(((MenuPacket)msg).POSITION);
            this.encode(msg, buf);
        }

        public abstract void encode(MSG var1, FriendlyByteBuf var2);

        public final MSG _decode(FriendlyByteBuf buf) {
            int containerId = buf.readInt();
            BlockPos pos = buf.m_130135_();
            return this.decode(containerId, pos, buf);
        }

        public abstract MSG decode(int var1, BlockPos var2, FriendlyByteBuf var3);

        public abstract void handle(MSG var1, MENU var2, BLOCK_ENTITY var3);

        public final void _handle(MSG msg, Supplier<NetworkEvent.Context> ctxSupplier) {
            if (ctxSupplier == null) {
                return;
            }
            NetworkEvent.Context ctx = ctxSupplier.get();
            if (ctx == null) {
                return;
            }
            ServerPlayer sender = ctx.getSender();
            if (sender == null) {
                return;
            }
            AbstractContainerMenu menu = sender.f_36096_;
            if (!this.MENU_CLASS.isInstance(menu)) {
                return;
            }
            if (menu.f_38840_ != ((MenuPacket)msg).CONTAINER_ID) {
                return;
            }
            ServerLevel level = sender.m_183503_();
            if (level == null) {
                return;
            }
            if (!level.m_46749_(((MenuPacket)msg).POSITION)) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(((MenuPacket)msg).POSITION);
            if (!this.BLOCK_ENTITY_CLASS.isInstance(blockEntity)) {
                return;
            }
            this.handle(msg, menu, (BaseContainerBlockEntity)blockEntity);
        }
    }
}

