/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.util.SFMLabelNBTHelper;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Trigger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.world.item.ItemStack;

public record Program(String name, List<Trigger> triggers, Set<String> referencedLabels) implements ASTNode
{
    public static final int MAX_PROGRAM_LENGTH = 8096;

    public void addWarnings(ItemStack disk) {
        ArrayList<String> warnings = new ArrayList<String>();
        for (String label : this.referencedLabels) {
            boolean isUsed = SFMLabelNBTHelper.getLabelPositions(disk, label).findAny().isPresent();
            if (isUsed) continue;
            warnings.add("There are no blocks labelled with \"" + label + "\".");
        }
        DiskItem.setWarnings(disk, warnings);
    }

    public void tick(ProgramContext context) {
        for (Trigger t : this.triggers) {
            if (!t.shouldTick(context)) continue;
            long start = System.nanoTime();
            t.tick(context);
            context.clear();
            long end = System.nanoTime();
            long l = end - start;
        }
    }

    public Set<String> getReferencedLabels() {
        return this.referencedLabels;
    }
}

