/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.util.SFMLabelNBTHelper;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.LabelAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ProgramContext {
    private final ManagerBlockEntity MANAGER;
    private final CableNetwork NETWORK;
    private final List<InputStatement> INPUTS = new ArrayList<InputStatement>();
    private final Level LEVEL;
    private final int REDSTONE_PULSES;

    public ProgramContext(ManagerBlockEntity manager) {
        this.MANAGER = manager;
        this.NETWORK = CableNetworkManager.getOrRegisterNetwork((BlockEntity)this.MANAGER).get();
        this.LEVEL = this.MANAGER.m_58904_();
        this.REDSTONE_PULSES = this.MANAGER.getUnprocessedRedstonePulseCount();
    }

    public ProgramContext(ProgramContext other) {
        this.MANAGER = other.MANAGER;
        this.NETWORK = other.NETWORK;
        this.LEVEL = other.LEVEL;
        this.REDSTONE_PULSES = other.REDSTONE_PULSES;
        this.INPUTS.addAll(other.INPUTS);
    }

    public int getRedstonePulses() {
        return this.REDSTONE_PULSES;
    }

    public ProgramContext fork() {
        return new ProgramContext(this);
    }

    public ManagerBlockEntity getManager() {
        return this.MANAGER;
    }

    public void addInput(InputStatement input) {
        this.INPUTS.add(input);
    }

    public Stream<InputStatement> getInputs() {
        return this.INPUTS.stream();
    }

    public Stream<IItemHandler> getItemHandlersByLabels(LabelAccess labelAccess) {
        ItemStack disk = this.MANAGER.getDisk().get();
        return SFMLabelNBTHelper.getPositions(disk, labelAccess.labels()).map(this.NETWORK::getInventory).filter(Optional::isPresent).map(Optional::get).flatMap(prov -> labelAccess.directions().stream().map(d -> prov.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d))).filter(LazyOptional::isPresent).map(x -> (IItemHandler)x.orElse(null)).filter(Objects::nonNull);
    }
}

