/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.program.LimitedInputSlot;
import ca.teamdman.sfm.common.program.LimitedOutputSlot;
import ca.teamdman.sfm.common.program.OutputItemMatcher;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Matchers;
import ca.teamdman.sfml.ast.Statement;
import java.util.List;
import java.util.stream.Stream;
import net.minecraftforge.items.IItemHandler;

public record OutputStatement(LabelAccess labelAccess, Matchers matchers, boolean each) implements Statement
{
    @Override
    public void tick(ProgramContext context) {
        Stream inputSlots = context.getInputs().flatMap(x -> x.getSlots(context));
        List<LimitedOutputSlot> outputSlots = this.getSlots(context).toList();
        block0: for (LimitedInputSlot in : inputSlots::iterator) {
            for (LimitedOutputSlot out : outputSlots) {
                in.moveTo(out);
                if (!in.isDone()) continue;
                continue block0;
            }
        }
    }

    public Stream<LimitedOutputSlot> getSlots(ProgramContext context) {
        Stream<IItemHandler> handlers = context.getItemHandlersByLabels(this.labelAccess);
        Stream.Builder<LimitedOutputSlot> rtn = Stream.builder();
        List<OutputItemMatcher> itemMatchers = null;
        for (IItemHandler inv : handlers::iterator) {
            if (itemMatchers == null || this.each) {
                itemMatchers = this.matchers.createOutputMatchers();
            }
            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                if (!this.labelAccess.slots().contains(slot)) continue;
                for (OutputItemMatcher matcher : itemMatchers) {
                    rtn.add(new LimitedOutputSlot(this, inv, slot, matcher));
                }
            }
        }
        return rtn.build();
    }
}

