/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.util.SFMLabelNBTHelper;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Trigger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public record Program(String name, List<Trigger> triggers, Set<String> referencedLabels) implements ASTNode
{
    public static final int MAX_PROGRAM_LENGTH = 8096;

    public void addWarnings(ItemStack disk, ManagerBlockEntity manager) {
        ArrayList<TranslatableContents> warnings = new ArrayList<TranslatableContents>();
        for (String label2 : this.referencedLabels) {
            boolean isUsed = SFMLabelNBTHelper.getLabelPositions(disk, label2).findAny().isPresent();
            if (isUsed) continue;
            warnings.add(new TranslatableContents("program.sfm.warnings.unused_label", new Object[]{label2}));
        }
        SFMLabelNBTHelper.getPositionLabels(disk).values().stream().distinct().filter(x -> !this.referencedLabels.contains(x)).forEach(label -> warnings.add(new TranslatableContents("program.sfm.warnings.undefined_label", new Object[]{label})));
        CableNetworkManager.getOrRegisterNetwork((BlockEntity)manager).ifPresent(network -> SFMLabelNBTHelper.getPositionLabels(disk).entries().stream().filter(e -> !network.containsInventoryLocation((BlockPos)e.getKey())).forEach(e -> warnings.add(new TranslatableContents("program.sfm.warnings.disconnected_label", new Object[]{e.getValue(), String.format("[%d,%d,%d]", ((BlockPos)e.getKey()).m_123341_(), ((BlockPos)e.getKey()).m_123342_(), ((BlockPos)e.getKey()).m_123343_())}))));
        DiskItem.setWarnings(disk, warnings);
    }

    public void fixWarnings(ItemStack disk, ManagerBlockEntity manager) {
        SFMLabelNBTHelper.getPositionLabels(disk).values().stream().distinct().filter(label -> !this.referencedLabels.contains(label)).forEach(label -> SFMLabelNBTHelper.removeLabel(disk, label));
        CableNetworkManager.getOrRegisterNetwork((BlockEntity)manager).ifPresent(network -> SFMLabelNBTHelper.getPositionLabels(disk).entries().stream().filter(e -> !network.containsInventoryLocation((BlockPos)e.getKey())).forEach(e -> SFMLabelNBTHelper.removeLabel(disk, (String)e.getValue(), (BlockPos)e.getKey())));
        this.addWarnings(disk, manager);
    }

    public void tick(ProgramContext context) {
        for (Trigger t : this.triggers) {
            if (!t.shouldTick(context)) continue;
            t.tick(context.fork());
        }
    }

    public Set<String> getReferencedLabels() {
        return this.referencedLabels;
    }
}

