/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.block;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.cablenetwork.ICable;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class ManagerBlock
extends BaseEntityBlock
implements EntityBlock,
ICable {
    public static final BooleanProperty TRIGGERED = BlockStateProperties.f_61360_;

    public ManagerBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76283_).m_155954_(2.0f).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TRIGGERED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighbourPos, boolean movedByPiston) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof ManagerBlockEntity)) {
            return;
        }
        ManagerBlockEntity mgr = (ManagerBlockEntity)blockEntity;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        CableNetworkManager.getOrRegisterNetwork(level, pos).ifPresent(network -> network.rebuildAdjacentInventories(pos));
        boolean isPowered = level.m_46753_(pos) || level.m_46753_(pos.m_7494_());
        Boolean debounce = (Boolean)state.m_61143_((Property)TRIGGERED);
        if (isPowered && !debounce.booleanValue()) {
            mgr.trackRedstonePulseUnprocessed();
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!isPowered && debounce.booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)SFMBlockEntities.MANAGER_BLOCK_ENTITY.get()).m_155264_(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ManagerBlockEntity) {
            ManagerBlockEntity tile = (ManagerBlockEntity)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)tile, buf -> {
                    buf.m_130064_(tile.m_58899_());
                    buf.m_130072_(tile.getProgram().orElse(""), 8096);
                });
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return null;
        }
        return ManagerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SFMBlockEntities.MANAGER_BLOCK_ENTITY.get()), ManagerBlockEntity::serverTick);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        CableNetworkManager.getOrRegisterNetwork(world, pos);
        CableNetworkManager.printDebugInfo();
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)container);
                level.m_46717_(pos, (Block)this);
            }
            CableNetworkManager.unregister(level, pos);
            CableNetworkManager.printDebugInfo();
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }
}

