/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.blockentity;

import ca.teamdman.sfm.common.block.WaterTankBlock;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaterTankBlockEntity
extends BlockEntity {
    public final FluidTank TANK = new FluidTank(1000, fluidStack -> false){
        {
            this.setFluid(new FluidStack((Fluid)Fluids.f_76193_, 1000));
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (!((Boolean)WaterTankBlockEntity.this.m_58904_().m_8055_(WaterTankBlockEntity.this.m_58899_()).m_61143_((Property)WaterTankBlock.IN_WATER)).booleanValue()) {
                return FluidStack.EMPTY;
            }
            int drained = Math.min(maxDrain, WaterTankBlockEntity.this.TANK.getCapacity());
            FluidStack copy = this.fluid.copy();
            copy.setAmount(drained);
            return copy;
        }
    };
    public final LazyOptional<IFluidHandler> TANK_CAPABILITY = LazyOptional.of(() -> this.TANK);

    public void setConnectedCount(int connectedCount) {
        this.TANK.setCapacity(connectedCount * 1000);
        this.TANK.getFluid().setAmount(this.TANK.getCapacity());
    }

    public void onLoad() {
        super.onLoad();
        ((WaterTankBlock)this.m_58900_().m_60734_()).recount(this.m_58904_(), this.m_58899_());
    }

    public WaterTankBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SFMBlockEntities.WATER_TANK_BLOCK_ENTITY.get(), pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.TANK_CAPABILITY.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.TANK_CAPABILITY.invalidate();
    }
}

