/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.cablenetwork.ICable;
import ca.teamdman.sfm.common.util.SFMUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CableNetwork {
    private final Level LEVEL;
    private final Set<BlockPos> CABLES = new HashSet<BlockPos>();
    private final Map<BlockPos, BlockEntity> INVENTORIES = new HashMap<BlockPos, BlockEntity>();

    public CableNetwork(Level level) {
        this.LEVEL = level;
    }

    private CableNetwork(Level level, Collection<BlockPos> init) {
        this(level);
        this.CABLES.addAll(init);
    }

    public static boolean isValidNetworkMember(Level world, BlockPos cablePos) {
        if (world == null) {
            return false;
        }
        return world.m_8055_(cablePos).m_60734_() instanceof ICable;
    }

    public void rebuildNetwork(BlockPos pos) {
        this.CABLES.clear();
        this.INVENTORIES.clear();
        this.discoverCables(pos).forEach(this::addCable);
    }

    public Stream<BlockPos> discoverCables(BlockPos startPos) {
        return SFMUtil.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            for (Direction d : Direction.values()) {
                BlockPos offset = current.m_121955_(d.m_122436_());
                if (!CableNetwork.isValidNetworkMember(this.getLevel(), offset)) continue;
                next.accept(offset);
            }
        }, startPos);
    }

    public boolean addCable(BlockPos pos) {
        boolean isNewMember = this.CABLES.add(pos);
        if (isNewMember) {
            this.rebuildAdjacentInventories(pos);
        }
        return isNewMember;
    }

    public Level getLevel() {
        return this.LEVEL;
    }

    public void rebuildAdjacentInventories(BlockPos pos) {
        Arrays.stream(Direction.values()).map(Direction::m_122436_).map(arg_0 -> ((BlockPos)pos).m_121955_(arg_0)).distinct().peek(this.INVENTORIES::remove).filter(this::hasCableNeighbour).map(arg_0 -> ((Level)this.LEVEL).m_7702_(arg_0)).filter(Objects::nonNull).forEach(tile -> this.INVENTORIES.put(tile.m_58899_(), (BlockEntity)tile));
    }

    public boolean hasCableNeighbour(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.CABLES.contains(pos.m_121955_(direction.m_122436_()))) continue;
            return true;
        }
        return false;
    }

    private Set<BlockPos> discoverKnownCables(BlockPos start) {
        return SFMUtil.getRecursiveStream((current, next, results) -> {
            if (!this.containsCableLocation((BlockPos)current)) {
                return;
            }
            results.accept(current);
            for (Direction direction : Direction.values()) {
                BlockPos offset = current.m_121955_(direction.m_122436_());
                next.accept(offset);
            }
        }, start).collect(Collectors.toSet());
    }

    public Set<CableNetwork> remove(BlockPos pos) {
        this.CABLES.remove(pos);
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<CableNetwork> networks = new HashSet<CableNetwork>();
        for (Direction direction : Direction.values()) {
            BlockPos offset = pos.m_121955_(direction.m_122436_());
            Set<BlockPos> branch = this.discoverKnownCables(offset);
            if (branch.isEmpty()) continue;
            CableNetwork network = this.getDerivativeNetwork(branch);
            networks.add(network);
        }
        return networks;
    }

    private CableNetwork getDerivativeNetwork(Set<BlockPos> positions) {
        CableNetwork network = new CableNetwork(this.getLevel(), positions);
        Set validInvPositions = positions.stream().flatMap(pos -> Arrays.stream(Direction.values()).map(Direction::m_122436_).map(arg_0 -> ((BlockPos)pos).m_121955_(arg_0))).collect(Collectors.toSet());
        this.INVENTORIES.entrySet().stream().filter(entry -> validInvPositions.contains(entry.getKey())).forEach(entry -> network.INVENTORIES.put((BlockPos)entry.getKey(), (BlockEntity)entry.getValue()));
        return network;
    }

    public boolean containsCableLocation(BlockPos pos) {
        return this.CABLES.contains(pos);
    }

    public boolean containsInventoryLocation(BlockPos pos) {
        return this.INVENTORIES.containsKey(pos);
    }

    public Optional<BlockEntity> getInventory(BlockPos pos) {
        return Optional.ofNullable(this.INVENTORIES.get(pos));
    }

    public int size() {
        return this.CABLES.size();
    }

    public void mergeNetwork(CableNetwork other) {
        this.CABLES.addAll(other.CABLES);
        this.INVENTORIES.putAll(other.INVENTORIES);
    }

    public boolean isEmpty() {
        return this.CABLES.isEmpty();
    }

    public Collection<BlockEntity> getInventories() {
        return this.INVENTORIES.values();
    }

    public ItemStack getPreview(BlockPos pos) {
        return new ItemStack((ItemLike)this.LEVEL.m_8055_(pos).m_60734_().m_5456_());
    }

    public Set<BlockPos> getCables() {
        return this.CABLES;
    }
}

