/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.program.InputResourceMatcher;
import ca.teamdman.sfm.common.program.LimitedOutputSlot;
import ca.teamdman.sfm.common.program.LimitedSlot;
import ca.teamdman.sfm.common.program.OutputResourceMatcher;
import ca.teamdman.sfml.ast.InputStatement;

public class LimitedInputSlot<STACK, CAP>
extends LimitedSlot<STACK, CAP, InputResourceMatcher<STACK, CAP>> {
    private final InputStatement<STACK, CAP> STATEMENT;

    public LimitedInputSlot(InputStatement<STACK, CAP> statement, CAP handler, int slot, InputResourceMatcher<STACK, CAP> matcher) {
        super(handler, matcher.LIMIT.resourceId().getType(), slot, matcher);
        this.STATEMENT = statement;
    }

    public InputStatement<STACK, CAP> getStatement() {
        return this.STATEMENT;
    }

    public void moveTo(LimitedOutputSlot<STACK, CAP> other) {
        Object potential = this.extract(Integer.MAX_VALUE, true);
        if (this.TYPE.isEmpty(potential)) {
            this.setDone();
            return;
        }
        if (!((InputResourceMatcher)this.MATCHER).test(potential)) {
            return;
        }
        if (!((OutputResourceMatcher)other.MATCHER).test(potential)) {
            return;
        }
        Object remainder = other.insert(potential, true);
        int toMove = this.TYPE.getCount(potential) - this.TYPE.getCount(remainder);
        if (toMove == 0) {
            return;
        }
        int toPromise = ((InputResourceMatcher)this.MATCHER).getRemainingPromise();
        toPromise = Math.min(toMove -= ((InputResourceMatcher)this.MATCHER).getExistingPromise(this.SLOT), toPromise);
        ((InputResourceMatcher)this.MATCHER).track(this.SLOT, 0, toPromise);
        if ((toMove -= toPromise) == 0) {
            this.setDone();
            return;
        }
        toMove = Math.min(toMove, ((OutputResourceMatcher)other.MATCHER).getMaxTransferable());
        if ((toMove = Math.min(toMove, ((InputResourceMatcher)this.MATCHER).getMaxTransferable())) <= 0) {
            return;
        }
        Object extracted = this.TYPE.extract(this.HANDLER, this.SLOT, toMove, false);
        remainder = other.TYPE.insert(other.HANDLER, other.SLOT, extracted, false);
        ((InputResourceMatcher)this.MATCHER).trackTransfer(toMove);
        ((OutputResourceMatcher)other.MATCHER).trackTransfer(toMove);
        if (!other.TYPE.isEmpty(remainder)) {
            SFM.LOGGER.error("Failed to move all promised items, took {} but had {} left over after insertion.", extracted, remainder);
        }
    }
}

