/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.util.SFMLabelNBTHelper;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;

public abstract class ResourceType<STACK, CAP> {
    public final Capability<CAP> CAPABILITY;

    public ResourceType(Capability<CAP> CAPABILITY) {
        this.CAPABILITY = CAPABILITY;
    }

    public abstract int getCount(STACK var1);

    public abstract STACK getStackInSlot(CAP var1, int var2);

    public abstract STACK extract(CAP var1, int var2, int var3, boolean var4);

    public abstract int getSlots(CAP var1);

    public abstract STACK insert(CAP var1, int var2, STACK var3, boolean var4);

    public abstract boolean isEmpty(STACK var1);

    public abstract boolean matchesStackType(Object var1);

    public boolean test(ResourceIdentifier<STACK, CAP> id, Object o) {
        if (id.type().equals("*") && id.domain().equals("*") && id.value().equals("*")) {
            return true;
        }
        if (!this.matchesStackType(o)) {
            return false;
        }
        if (id.domain().equals("*") && id.value().equals("*")) {
            return true;
        }
        ResourceLocation key = this.getKey(o);
        if (key == null) {
            return false;
        }
        if (id.domain().equals("*")) {
            return id.value().equals(key.m_135815_());
        }
        if (id.value().equals("*")) {
            return id.domain().equals(key.m_135827_());
        }
        return id.domain().equals(key.m_135827_()) && id.value().equals(key.m_135815_());
    }

    public abstract boolean matchesCapType(Object var1);

    public Stream<CAP> getCaps(ProgramContext programContext, LabelAccess labelAccess) {
        Optional<ItemStack> disk = programContext.getManager().getDisk();
        if (disk.isEmpty()) {
            return Stream.empty();
        }
        return SFMLabelNBTHelper.getPositions(disk.get(), labelAccess.labels()).map(programContext.getNetwork()::getInventory).filter(Optional::isPresent).map(Optional::get).flatMap(prov -> labelAccess.directions().stream().map(direction -> prov.getCapability(this.CAPABILITY, direction))).map(x -> x.orElse(null)).filter(Objects::nonNull);
    }

    public abstract Stream<STACK> collect(CAP var1, LabelAccess var2);

    public abstract boolean containsKey(ResourceLocation var1);

    public abstract ResourceLocation getKey(STACK var1);
}

