/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.supernatural.entity.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.mcreator.supernatural.entity.GhostEntity;
import net.mcreator.supernatural.procedures.SpookyGhostProcedure;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

@OnlyIn(value=Dist.CLIENT)
public class GhostRenderer {
    @OnlyIn(value=Dist.CLIENT)
    public static void addBoxHelper(ModelRenderer renderer, int texU, int texV, float x, float y, float z, int dx, int dy, int dz, float delta) {
        GhostRenderer.addBoxHelper(renderer, texU, texV, x, y, z, dx, dy, dz, delta, renderer.field_78809_i);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addBoxHelper(ModelRenderer renderer, int texU, int texV, float x, float y, float z, int dx, int dy, int dz, float delta, boolean mirror) {
        renderer.field_78809_i = mirror;
        renderer.func_217178_a("", x, y, z, dx, dy, dz, delta, texU, texV);
    }

    public static class ModelGhost
    extends EntityModel<GhostEntity.CustomEntity> {
        private final ModelRenderer head;
        private final ModelRenderer jaw;
        private final ModelRenderer body;
        private final ModelRenderer left_arm;
        private final ModelRenderer right_arm;

        public ModelGhost() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.head = new ModelRenderer((Model)this);
            this.head.func_78793_a(0.0f, 0.0f, 0.0f);
            GhostRenderer.addBoxHelper(this.head, 0, 0, -4.0f, -8.0f, -4.0f, 8, 6, 8, 0.0f, false);
            GhostRenderer.addBoxHelper(this.head, 32, 0, -4.0f, -8.0f, -4.0f, 8, 13, 8, 0.5f, false);
            this.jaw = new ModelRenderer((Model)this);
            this.jaw.func_78793_a(0.0f, -2.0f, 4.0f);
            this.head.func_78792_a(this.jaw);
            GhostRenderer.addBoxHelper(this.jaw, 0, 40, -4.0f, 0.0f, -8.0f, 8, 2, 8, 0.0f, false);
            GhostRenderer.addBoxHelper(this.jaw, 0, 40, -4.0f, 1.0f, -8.0f, 8, 0, 8, 0.0f, false);
            this.body = new ModelRenderer((Model)this);
            this.body.func_78793_a(0.0f, 0.0f, 0.0f);
            GhostRenderer.addBoxHelper(this.body, 4, 16, -4.0f, 0.0f, -2.0f, 8, 20, 4, 0.49f, false);
            GhostRenderer.addBoxHelper(this.body, 40, 21, -4.0f, 0.0f, -2.0f, 8, 12, 4, 0.0f, false);
            GhostRenderer.addBoxHelper(this.body, 8, 50, -1.0f, 0.0f, 0.0f, 2, 12, 2, -0.01f, false);
            this.left_arm = new ModelRenderer((Model)this);
            this.left_arm.func_78793_a(4.0f, 2.0f, 0.0f);
            GhostRenderer.addBoxHelper(this.left_arm, 48, 48, 0.5f, -2.0f, -2.0f, 4, 12, 4, 0.0f, true);
            GhostRenderer.addBoxHelper(this.left_arm, 0, 50, 1.0f, -2.0f, -1.0f, 2, 12, 2, -0.01f, true);
            this.right_arm = new ModelRenderer((Model)this);
            this.right_arm.func_78793_a(-4.0f, 2.0f, 0.0f);
            GhostRenderer.addBoxHelper(this.right_arm, 0, 50, -3.0f, -2.0f, -1.0f, 2, 12, 2, -0.01f, false);
            GhostRenderer.addBoxHelper(this.right_arm, 48, 48, -4.5f, -2.0f, -2.0f, 4, 12, 4, 0.0f, false);
        }

        public void func_225598_a_(MatrixStack ms, IVertexBuilder vb, int i1, int i2, float f1, float f2, float f3, float f4) {
            this.head.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.body.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.left_arm.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
            this.right_arm.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void setRotationAngles(GhostEntity.CustomEntity ghost, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
            this.head.field_78796_g = headYaw / 57.295776f;
            this.head.field_78795_f = headPitch / 57.295776f;
            this.body.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.body.field_78795_f = 0.1745f;
            this.body.field_78795_f += MathHelper.func_76134_b((float)(ageInTicks * 0.04f)) * 0.08f + 0.08f;
            this.body.field_78796_g = 0.0f;
            this.body.field_78808_h = 0.0f;
            this.jaw.field_78795_f = 0.0873f;
            this.jaw.field_78795_f += MathHelper.func_76134_b((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
            this.right_arm.field_78795_f = -0.5236f;
            this.left_arm.field_78795_f = -0.5236f;
            this.right_arm.field_78795_f += MathHelper.func_76134_b((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
            this.left_arm.field_78795_f -= MathHelper.func_76134_b((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
            this.right_arm.field_78796_g = 0.0f;
            this.left_arm.field_78796_g = 0.0f;
            this.right_arm.field_78808_h = 0.0873f;
            this.left_arm.field_78808_h = -0.0873f;
            this.right_arm.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
            this.left_arm.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
            if (ghost.func_213398_dR()) {
                this.body.field_78795_f = 0.6981f;
                this.body.field_78795_f += MathHelper.func_76134_b((float)(ageInTicks * 0.08f)) * 0.08f + 0.08f;
                this.jaw.field_78795_f = 0.2618f;
                this.jaw.field_78795_f += MathHelper.func_76134_b((float)(ageInTicks * 0.08f)) * 0.04f + 0.04f;
                this.right_arm.field_78795_f = -1.4086f;
                this.left_arm.field_78795_f = -1.5788f;
                this.right_arm.field_78795_f += MathHelper.func_76134_b((float)(ageInTicks * 0.12f)) * 0.08f + 0.08f;
                this.left_arm.field_78795_f -= MathHelper.func_76134_b((float)(ageInTicks * 0.12f)) * 0.08f + 0.08f;
                this.right_arm.field_78796_g = 0.343f;
                this.left_arm.field_78796_g = -0.5364f;
                this.right_arm.field_78808_h = 0.3367f;
                this.left_arm.field_78808_h = -0.1466f;
                this.right_arm.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.12f)) * 0.08f + 0.08f;
                this.left_arm.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.12f)) * 0.08f + 0.08f;
            }
            if (this.field_217112_c > 0.0f) {
                float progress = this.field_217112_c;
                progress = 1.0f - this.field_217112_c;
                progress *= progress;
                progress *= progress;
                progress = 1.0f - progress;
                float f2 = MathHelper.func_76126_a((float)(progress * (float)Math.PI));
                this.right_arm.field_78795_f = (float)((double)this.right_arm.field_78795_f - ((double)f2 / 1.2 - 1.0));
                this.left_arm.field_78795_f = (float)((double)this.left_arm.field_78795_f - ((double)f2 / 1.2 - 1.0));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GlowingLayer<T extends Entity, M extends EntityModel<T>>
    extends LayerRenderer<T, M> {
        public GlowingLayer(IEntityRenderer<T, M> er) {
            super(er);
        }

        public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entity.func_145748_c_().getString().equals("Classic")) {
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("supernatural:textures/ghost_blue_glow.png")));
                this.func_215332_c().func_225598_a_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("supernatural:textures/ghost_glow.png")));
                this.func_215332_c().func_225598_a_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public static class ModelRegisterHandler {
        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerModels(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)GhostEntity.entity, renderManager -> new MobRenderer(renderManager, new ModelGhost(), 0.5f){
                {
                    super(x0, x1, x2);
                    this.func_177094_a(new GlowingLayer(this));
                }

                public ResourceLocation func_110775_a(Entity entity) {
                    if (entity.func_145748_c_().getString().equals("Classic")) {
                        return new ResourceLocation("supernatural:textures/ghost_blue.png");
                    }
                    return new ResourceLocation("supernatural:textures/ghost.png");
                }

                protected boolean func_225622_a_(LivingEntity _ent) {
                    LivingEntity entity = _ent;
                    World world = entity.field_70170_p;
                    double x = entity.func_226277_ct_();
                    double y = entity.func_226278_cu_();
                    double z = entity.func_226281_cx_();
                    return !SpookyGhostProcedure.executeProcedure(Stream.of(new AbstractMap.SimpleEntry<String, LivingEntity>("entity", entity)).collect(HashMap::new, (_m, _e) -> _m.put(_e.getKey(), _e.getValue()), Map::putAll));
                }
            });
        }
    }
}

