/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.supernatural.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.Monster;

public class GhostModel<T extends Monster>
extends EntityModel<T> {
    public static final ModelLayerLocation GHOST_MODEL = new ModelLayerLocation(new ResourceLocation("supernatural", "ghost"), "main");
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart body;
    private final ModelPart rightarm;
    private final ModelPart leftarm;

    public GhostModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.jaw = root.m_171324_("jaw");
        this.body = root.m_171324_("body");
        this.rightarm = root.m_171324_("rightarm");
        this.leftarm = root.m_171324_("leftarm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -7.0f, -6.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)2.0f));
        PartDefinition headwear = head.m_171599_("headwear", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 13.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)-2.0f));
        PartDefinition jaw = partdefinition.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171488_(-4.0f, -1.0f, -6.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 40).m_171488_(-4.0f, 0.0f, -6.0f, 8.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)2.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(4, 16).m_171488_(-4.0f, 1.0f, -4.0f, 8.0f, 20.0f, 4.0f, new CubeDeformation(0.49f)).m_171514_(40, 21).m_171488_(-4.0f, 1.0f, -4.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(8, 50).m_171488_(-1.0f, 1.0f, -2.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)2.0f));
        PartDefinition rightarm = partdefinition.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171488_(-3.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(-0.01f)).m_171514_(48, 48).m_171488_(-4.5f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftarm = partdefinition.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171480_().m_171488_(0.5f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 50).m_171480_().m_171488_(1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(-0.01f)).m_171555_(false), PartPose.m_171419_((float)4.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setRotateAngle(ModelPart ModelRenderer, float x, float y, float z) {
        ModelRenderer.f_104203_ = x;
        ModelRenderer.f_104204_ = y;
        ModelRenderer.f_104205_ = z;
    }

    public void setupAnim(T ghost, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.jaw.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.jaw.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.jaw.f_104203_ = 0.0873f;
        this.jaw.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
        this.body.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.body.f_104203_ = 0.1745f;
        this.body.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.04f)) * 0.08f + 0.08f;
        this.body.f_104204_ = 0.0f;
        this.body.f_104205_ = 0.0f;
        this.rightarm.f_104203_ = -0.5236f;
        this.leftarm.f_104203_ = -0.5236f;
        this.rightarm.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
        this.leftarm.f_104203_ -= Mth.m_14089_((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
        this.rightarm.f_104204_ = 0.0f;
        this.leftarm.f_104204_ = 0.0f;
        this.rightarm.f_104205_ = 0.0873f;
        this.leftarm.f_104205_ = -0.0873f;
        this.rightarm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
        this.leftarm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
        if (ghost.m_5912_()) {
            this.jaw.f_104203_ = 0.4521f;
            this.jaw.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.08f)) * 0.04f + 0.04f;
            this.body.f_104203_ = 0.6981f;
            this.body.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.08f)) * 0.08f + 0.08f;
            this.rightarm.f_104203_ = -1.4086f;
            this.leftarm.f_104203_ = -1.5788f;
            this.rightarm.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.12f)) * 0.08f + 0.08f;
            this.leftarm.f_104203_ -= Mth.m_14089_((float)(ageInTicks * 0.12f)) * 0.08f + 0.08f;
            this.rightarm.f_104204_ = 0.343f;
            this.leftarm.f_104204_ = -0.5364f;
            this.rightarm.f_104205_ = 0.3367f;
            this.leftarm.f_104205_ = -0.1466f;
            this.rightarm.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.12f)) * 0.08f + 0.08f;
            this.leftarm.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.12f)) * 0.08f + 0.08f;
        }
        if (this.f_102608_ > 0.0f) {
            this.rightarm.f_104203_ = -2.281f;
            this.leftarm.f_104203_ = -2.3309f;
            this.rightarm.f_104204_ = 0.3959f;
            this.leftarm.f_104204_ = -0.6405f;
            this.rightarm.f_104205_ = -0.2805f;
            this.leftarm.f_104205_ = 0.2327f;
            float progress = this.f_102608_;
            progress = 1.0f - this.f_102608_;
            progress *= progress;
            progress *= progress;
            progress = 1.0f - progress;
            float f2 = Mth.m_14031_((float)(progress * (float)Math.PI));
            this.rightarm.f_104203_ = (float)((double)this.rightarm.f_104203_ - (double)f2 / 0.5 - 0.3);
            this.leftarm.f_104203_ = (float)((double)this.leftarm.f_104203_ - (double)f2 / 0.5 - 0.3);
        }
    }

    public void setAllVisible(boolean atlas) {
        this.head.f_104207_ = atlas;
        this.jaw.f_104207_ = atlas;
        this.body.f_104207_ = atlas;
        this.rightarm.f_104207_ = atlas;
        this.leftarm.f_104207_ = atlas;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.jaw.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightarm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftarm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

