/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.supernatural.entity;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.mcreator.supernatural.init.SupernaturalModEntities;
import net.mcreator.supernatural.procedures.VampireCombatProcedure;
import net.mcreator.supernatural.procedures.VampireSpawnProcedure;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class VampireEntity
extends AbstractIllager {
    private static final String TAG_JOHNNY = "Johnny";
    static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = pip -> pip == Difficulty.NORMAL || pip == Difficulty.HARD;
    boolean isJohnny;

    public VampireEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<VampireEntity>)((EntityType)SupernaturalModEntities.VAMPIRE.get()), world);
    }

    public VampireEntity(EntityType<VampireEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 8;
        this.m_21557_(false);
        this.m_21530_();
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new VampireBreakDoorGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(3, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new VampireJohnnyAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8024_() {
        if (!this.m_21525_() && GoalUtils.m_26894_((Mob)this)) {
            boolean flag = ((ServerLevel)this.f_19853_).m_8843_(this.m_142538_());
            ((GroundPathNavigation)this.m_21573_()).m_26477_(flag);
        }
        super.m_8024_();
    }

    public void m_8107_() {
        boolean flag = this.m_21527_();
        if (flag) {
            this.m_20254_(8);
        }
        super.m_8107_();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.isJohnny) {
            tag.m_128379_(TAG_JOHNNY, true);
        }
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_5912_()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_(TAG_JOHNNY, 99)) {
            this.isJohnny = tag.m_128471_(TAG_JOHNNY);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21643_;
    }

    public boolean m_7307_(Entity ally) {
        if (super.m_7307_(ally)) {
            return true;
        }
        if (ally instanceof LivingEntity && ((LivingEntity)ally).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && ally.m_5647_() == null;
        }
        return false;
    }

    public void m_6593_(@Nullable Component pony) {
        super.m_6593_(pony);
        if (!this.isJohnny && pony != null && pony.getString().equals(TAG_JOHNNY)) {
            this.isJohnny = true;
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_7895_(int imp, boolean boop) {
        Raid raid = this.m_37885_();
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("supernatural:vampire_idle"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("supernatural:vampire_hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("supernatural:vampire_death"));
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("supernatural:vampire_celebrate"));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        VampireSpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void m_6075_() {
        super.m_6075_();
        VampireCombatProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22277_, 12.0);
        builder = builder.m_22268_(Attributes.f_22276_, 24.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        return builder;
    }

    static class VampireBreakDoorGoal
    extends BreakDoorGoal {
        public VampireBreakDoorGoal(Mob vampy) {
            super(vampy, 6, DOOR_BREAKING_PREDICATE);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8045_() {
            VampireEntity vampire = (VampireEntity)this.f_25189_;
            return vampire.m_37886_() && super.m_8045_();
        }

        public boolean m_8036_() {
            VampireEntity vampire = (VampireEntity)this.f_25189_;
            return vampire.m_37886_() && vampire.f_19796_.nextInt(VampireBreakDoorGoal.m_186073_((int)10)) == 0 && super.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.f_25189_.m_21310_(0);
        }
    }

    static class VampireJohnnyAttackGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public VampireJohnnyAttackGoal(VampireEntity vampy) {
            super((Mob)vampy, LivingEntity.class, 0, true, true, LivingEntity::m_5789_);
        }

        public boolean m_8036_() {
            return ((VampireEntity)this.f_26135_).isJohnny && super.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.f_26135_.m_21310_(0);
        }
    }
}

