/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.salju.supernatural.init.SupernaturalEventHandler;
import net.salju.supernatural.init.SupernaturalModBlocks;
import net.salju.supernatural.init.SupernaturalModEnchantments;
import net.salju.supernatural.init.SupernaturalModEntities;
import net.salju.supernatural.init.SupernaturalModItems;
import net.salju.supernatural.init.SupernaturalModMobEffects;
import net.salju.supernatural.init.SupernaturalModSounds;
import net.salju.supernatural.init.SupernaturalModTabs;

@Mod(value="supernatural")
public class SupernaturalMod {
    public static final String MODID = "supernatural";
    public static SupernaturalEventHandler supernaturalHandler;
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER;
    private static int messageID;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue;

    public SupernaturalMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        SupernaturalModTabs.load();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        SupernaturalModSounds.REGISTRY.register(bus);
        SupernaturalModBlocks.REGISTRY.register(bus);
        SupernaturalModItems.REGISTRY.register(bus);
        SupernaturalModEntities.REGISTRY.register(bus);
        SupernaturalModMobEffects.REGISTRY.register(bus);
        SupernaturalModEnchantments.REGISTRY.register(bus);
        supernaturalHandler = new SupernaturalEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)supernaturalHandler);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }

    static {
        PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, MODID), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        messageID = 0;
        workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();
    }
}

