/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Vex;
import net.salju.supernatural.entity.SpookyEntity;

public class SpiritModel<T extends Monster>
extends HierarchicalModel<T>
implements ArmedModel {
    public static final ModelLayerLocation SPIRIT_MODEL = new ModelLayerLocation(new ResourceLocation("supernatural", "spirit"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart head;

    public SpiritModel(ModelPart rwt) {
        super(RenderType::m_110473_);
        this.root = rwt.m_171324_("root");
        this.body = this.root.m_171324_("body");
        this.rightArm = this.body.m_171324_("right_arm");
        this.leftArm = this.body.m_171324_("left_arm");
        this.rightWing = this.body.m_171324_("right_wing");
        this.leftWing = this.body.m_171324_("left_wing");
        this.head = this.root.m_171324_("head");
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition partdefinition1 = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)0.0f));
        partdefinition1.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -5.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition partdefinition2 = partdefinition1.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 16).m_171488_(-1.5f, 1.0f, -1.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)0.0f));
        partdefinition2.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(23, 0).m_171488_(-1.25f, -0.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.m_171419_((float)-1.75f, (float)0.25f, (float)0.0f));
        partdefinition2.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(23, 6).m_171488_(-0.75f, -0.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.m_171419_((float)1.75f, (float)0.25f, (float)0.0f));
        partdefinition2.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171480_().m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.5f, (float)1.0f, (float)1.0f));
        partdefinition2.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(16, 14).m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)1.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T spirit, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float f12;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        float f = ageInTicks * 20.0f * ((float)Math.PI / 180) + limbSwingAmount;
        float f1 = Mth.m_14089_((float)f) * (float)Math.PI * 0.15f;
        float f3 = ageInTicks * 9.0f * ((float)Math.PI / 180);
        float f4 = Math.min(limbSwingAmount / 0.3f, 1.0f);
        float f5 = 1.0f - f4;
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.rightWing.f_104203_ = 0.43633232f;
        this.rightWing.f_104204_ = -0.61086524f + f1;
        this.leftWing.f_104203_ = 0.43633232f;
        this.leftWing.f_104204_ = 0.61086524f - f1;
        this.body.f_104203_ = f12 = f4 * 0.6981317f;
        float f13 = Mth.m_14179_((float)f4, (float)f12, (float)Mth.m_14179_((float)f4, (float)-1.0471976f, (float)-0.7853982f));
        this.root.f_104201_ += (float)Math.cos(f3) * 0.25f * f5;
        this.rightArm.f_104203_ = f13;
        this.leftArm.f_104203_ = f13;
        float f14 = f5 * (1.0f - f4);
        float f15 = 0.43633232f - Mth.m_14089_((float)(f3 + 4.712389f)) * (float)Math.PI * 0.075f * f14;
        this.leftArm.f_104205_ = -f15;
        this.rightArm.f_104205_ = f15;
        this.rightArm.f_104204_ = 0.27925268f * f4;
        this.leftArm.f_104204_ = -0.27925268f * f4;
        if (spirit instanceof Vex) {
            Vex ghost = (Vex)spirit;
            if (ghost.m_34028_()) {
                this.body.f_104203_ = 0.0f;
                this.rightArm.f_104203_ = 3.6651914f;
                this.rightArm.f_104204_ = 0.2617994f;
                this.rightArm.f_104205_ = -0.47123888f;
            }
        } else if (spirit instanceof SpookyEntity && spirit.m_5912_()) {
            this.rightArm.f_104203_ = 4.712389f;
            this.leftArm.f_104203_ = 4.712389f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104301_(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public void m_6002_(HumanoidArm arm, PoseStack pose) {
        boolean flag = arm == HumanoidArm.RIGHT;
        ModelPart modelpart = flag ? this.rightArm : this.leftArm;
        this.root.m_104299_(pose);
        this.body.m_104299_(pose);
        modelpart.m_104299_(pose);
        pose.m_85841_(0.55f, 0.55f, 0.55f);
        this.offsetStackPosition(pose, flag);
    }

    private void offsetStackPosition(PoseStack pose, boolean arm) {
        if (arm) {
            pose.m_85837_(0.046875, -0.15625, 0.078125);
        } else {
            pose.m_85837_(-0.046875, -0.15625, 0.078125);
        }
    }
}

