/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.salju.supernatural.entity.MerAmethystEntity;
import net.salju.supernatural.init.SupernaturalModSounds;

public class AbstractMerEntity
extends Monster
implements RangedAttackMob {
    public boolean merTick = true;

    public AbstractMerEntity(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.f_21364_ = 5;
        this.f_21342_ = new MerMoveControl(this);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MerTridentAttackGoal(this, 1.0, 40, 10.0f));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.6, false));
        this.f_21345_.m_25352_(3, (Goal)new MerSwimGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 12, true, true, (Predicate)new MerAttackSelector(this)));
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.15;
    }

    protected PathNavigation m_6037_(Level lvl) {
        return new WaterBoundPathNavigation((Mob)this, lvl);
    }

    public void m_6504_(LivingEntity target, float tri) {
        if (this.m_21205_().m_41720_() instanceof TridentItem) {
            ThrownTrident throwntrident = new ThrownTrident(this.f_19853_, (LivingEntity)this, new ItemStack((ItemLike)Items.f_42713_));
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20227_(0.3333333333333333) - throwntrident.m_20186_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            throwntrident.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
            this.m_5496_(SoundEvents.f_11821_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.f_19853_.m_7967_((Entity)throwntrident);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return true;
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_7023_(Vec3 vec) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.01f, vec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(vec);
        }
    }

    boolean wantsToSwim() {
        LivingEntity livingentity = this.m_5448_();
        return livingentity != null && livingentity.m_20069_();
    }

    public void m_5844_() {
        if (!this.f_19853_.f_46443_) {
            if (this.m_6142_() && this.m_20069_() && this.wantsToSwim()) {
                this.m_20282_(true);
            } else {
                this.m_20282_(false);
            }
        }
    }

    protected boolean closeToNextPos() {
        double d0;
        BlockPos blockpos;
        Path path = this.m_21573_().m_26570_();
        return path != null && (blockpos = path.m_77406_()) != null && (d0 = this.m_20275_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_())) < 4.0;
    }

    protected boolean canRandomSwim() {
        return true;
    }

    protected void handleAirSupply(int air) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(air - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(DamageSource.f_19312_, 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public SoundEvent m_7515_() {
        if (this.m_20069_()) {
            return (SoundEvent)SupernaturalModSounds.MERWATER_IDLE.get();
        }
        return (SoundEvent)SupernaturalModSounds.MERLAND_IDLE.get();
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        if (this.m_20069_()) {
            this.m_5496_(SoundEvents.f_11876_, 0.15f, 1.0f);
        }
    }

    public SoundEvent m_7975_(DamageSource ds) {
        if (this.m_20069_()) {
            return (SoundEvent)SupernaturalModSounds.MERWATER_HURT.get();
        }
        return (SoundEvent)SupernaturalModSounds.MERLAND_HURT.get();
    }

    public SoundEvent m_5592_() {
        if (this.m_20069_()) {
            return (SoundEvent)SupernaturalModSounds.MERWATER_DEATH.get();
        }
        return (SoundEvent)SupernaturalModSounds.MERLAND_DEATH.get();
    }

    public boolean m_7327_(Entity target) {
        if (super.m_7327_(target)) {
            if (this.m_21526_()) {
                this.m_21559_(false);
            } else {
                this.m_21559_(true);
            }
            return true;
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof Projectile) {
            Projectile proj = (Projectile)source.m_7640_();
            if (proj.m_37282_() instanceof AbstractMerEntity) {
                return false;
            }
        } else if (source.m_7640_() instanceof Drowned) {
            return super.m_6469_(source, 1.0f);
        }
        return super.m_6469_(source, amount);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        if (!(this instanceof MerAmethystEntity)) {
            ItemStack trident = new ItemStack((ItemLike)Items.f_42713_);
            trident.m_41764_(1);
            this.m_21008_(InteractionHand.MAIN_HAND, trident);
        }
        this.merTick = false;
        return retval;
    }

    static class MerMoveControl
    extends MoveControl {
        private final AbstractMerEntity mer;

        public MerMoveControl(AbstractMerEntity ent) {
            super((Mob)ent);
            this.mer = ent;
        }

        public void m_8126_() {
            if (this.mer.m_204029_(FluidTags.f_13131_)) {
                this.mer.m_20256_(this.mer.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.mer.m_21573_().m_26571_()) {
                float f = (float)(this.f_24978_ * this.mer.m_21133_(Attributes.f_22279_));
                this.mer.m_7910_(Mth.m_14179_((float)0.125f, (float)this.mer.m_6113_(), (float)f));
                double d0 = this.f_24975_ - this.mer.m_20185_();
                double d1 = this.f_24976_ - this.mer.m_20186_();
                double d2 = this.f_24977_ - this.mer.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                if (d1 != 0.0) {
                    if (this.mer.m_5912_()) {
                        this.mer.m_20256_(this.mer.m_20184_().m_82520_(0.0, (double)this.mer.m_6113_() * (d1 / d3) * 0.06, 0.0));
                    } else {
                        this.mer.m_20256_(this.mer.m_20184_().m_82520_(0.0, (double)this.mer.m_6113_() * (d1 / d3) * 0.035, 0.0));
                    }
                }
                if (d0 != 0.0 || d2 != 0.0) {
                    float f1 = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.mer.m_146922_(this.m_24991_(this.mer.m_146908_(), f1, 90.0f));
                    this.mer.f_20883_ = this.mer.m_146908_();
                    if (this.mer.m_5912_()) {
                        this.mer.m_20256_(this.mer.m_20184_().m_82520_((double)this.mer.m_6113_() * (d0 / d3) * 0.06, 0.0, (double)this.mer.m_6113_() * (d2 / d3) * 0.06));
                    } else {
                        this.mer.m_20256_(this.mer.m_20184_().m_82520_((double)this.mer.m_6113_() * (d0 / d3) * 0.035, 0.0, (double)this.mer.m_6113_() * (d2 / d3) * 0.035));
                    }
                }
            } else {
                this.mer.m_7910_(0.0f);
            }
        }
    }

    static class MerTridentAttackGoal
    extends RangedAttackGoal {
        private final AbstractMerEntity mer;

        public MerTridentAttackGoal(RangedAttackMob mob, double tri, int tru, float tre) {
            super(mob, tri, tru, tre);
            this.mer = (AbstractMerEntity)mob;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.mer.m_21205_().m_41720_() == Items.f_42713_;
        }

        public void m_8056_() {
            super.m_8056_();
            this.mer.m_21561_(true);
            this.mer.m_6672_(InteractionHand.MAIN_HAND);
        }

        public void m_8041_() {
            super.m_8041_();
            this.mer.m_5810_();
            this.mer.m_21561_(false);
        }
    }

    static class MerSwimGoal
    extends RandomSwimmingGoal {
        private final AbstractMerEntity mer;

        public MerSwimGoal(AbstractMerEntity ent) {
            super((PathfinderMob)ent, 1.0, 40);
            this.mer = ent;
        }

        public boolean m_8036_() {
            return this.mer.canRandomSwim() && super.m_8036_() && !this.mer.m_5912_();
        }
    }

    static class MerAttackSelector
    implements Predicate<LivingEntity> {
        private final AbstractMerEntity mer;

        public MerAttackSelector(AbstractMerEntity source) {
            this.mer = source;
        }

        @Override
        public boolean test(@Nullable LivingEntity target) {
            return target instanceof Player || target instanceof Drowned || target instanceof GlowSquid;
        }
    }
}

