/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.salju.supernatural.entity.PossessedArmorEntity;
import net.salju.supernatural.init.SupernaturalModEntities;
import net.salju.supernatural.init.SupernaturalModMobEffects;
import net.salju.supernatural.init.SupernaturalModSounds;
import net.salju.supernatural.network.SupernaturalModVariables;

public class SpookyEntity
extends Monster {
    private static final Predicate<Entity> AVOID_PLAYERS = player -> !player.m_20163_() && EntitySelector.f_20406_.test(player);

    public SpookyEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SpookyEntity>)((EntityType)SupernaturalModEntities.SPOOKY.get()), world);
    }

    public SpookyEntity(EntityType<SpookyEntity> type, Level world) {
        super(type, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21364_ = 2;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level lvl) {
        FlyingPathNavigation scary = new FlyingPathNavigation((Mob)this, lvl);
        scary.m_26440_(false);
        scary.m_7008_(true);
        scary.m_26443_(true);
        return scary;
    }

    protected float m_6431_(Pose pose, EntityDimensions ent) {
        return ent.f_20378_ * 0.6f;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 4.0f, 1.4, 1.2, player -> AVOID_PLAYERS.test((Entity)player)));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.8, false));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, ArmorStand.class, true, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 12, true, true, (Predicate)new SpookAttackSelector(this)));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.m_21532_();
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)SupernaturalModSounds.GHOST_IDLE.get();
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)SupernaturalModSounds.GHOST_WALK.get(), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)SupernaturalModSounds.GHOST_HURT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)SupernaturalModSounds.GHOST_DEATH.get();
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_20242_(true);
    }

    public boolean m_7327_(Entity entity) {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        if (super.m_7327_(entity) && entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (target instanceof Animal || target instanceof Monster || target instanceof Slime) {
                target.m_7292_(new MobEffectInstance((MobEffect)SupernaturalModMobEffects.POSSESSION.get(), 6000, 0));
            } else if (target instanceof Player) {
                target.m_7292_(new MobEffectInstance((MobEffect)SupernaturalModMobEffects.POSSESSION.get(), 3000, 0));
                target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 32, 0, false, false));
            }
            if (!this.f_19853_.m_5776_()) {
                this.m_5496_((SoundEvent)SupernaturalModSounds.GHOST_POOF.get(), 1.0f, 1.0f);
                this.m_146870_();
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)level;
                    double r = this.f_19796_.m_188583_() * 0.02;
                    lvl.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 10, r, r, r, 0.25);
                }
            }
        }
        return false;
    }

    public void m_6075_() {
        super.m_6075_();
        for (ArmorStand target : this.f_19853_.m_45976_(ArmorStand.class, this.m_20191_().m_82400_(0.85))) {
            Object armor;
            Level lvl;
            Level world = target.f_19853_;
            double x = target.m_20185_();
            double y = target.m_20186_();
            double z2 = target.m_20189_();
            if (target.m_6844_(EquipmentSlot.HEAD) != ItemStack.f_41583_ && target.m_6844_(EquipmentSlot.CHEST) != ItemStack.f_41583_ && target.m_6844_(EquipmentSlot.LEGS) != ItemStack.f_41583_ && target.m_6844_(EquipmentSlot.FEET) != ItemStack.f_41583_) {
                SupernaturalModVariables.Armor3 = target.m_6844_(EquipmentSlot.HEAD);
                SupernaturalModVariables.Armor2 = target.m_6844_(EquipmentSlot.CHEST);
                SupernaturalModVariables.Armor1 = target.m_6844_(EquipmentSlot.LEGS);
                SupernaturalModVariables.Armor0 = target.m_6844_(EquipmentSlot.FEET);
                target.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                target.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
                target.m_8061_(EquipmentSlot.LEGS, ItemStack.f_41583_);
                target.m_8061_(EquipmentSlot.FEET, ItemStack.f_41583_);
                this.m_5496_((SoundEvent)SupernaturalModSounds.GHOST_POOF.get(), 1.0f, 1.0f);
                if (world instanceof ServerLevel) {
                    lvl = (ServerLevel)world;
                    armor = new PossessedArmorEntity((EntityType<PossessedArmorEntity>)((EntityType)SupernaturalModEntities.POSSESSED_ARMOR.get()), lvl);
                    armor.m_7678_(x, y, z2, world.m_213780_().m_188501_() * 360.0f, 0.0f);
                    armor.m_6518_((ServerLevelAccessor)lvl, world.m_6436_(armor.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    world.m_7967_((Entity)armor);
                    this.m_146870_();
                    double r = this.f_19796_.m_188583_() * 0.02;
                    lvl.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 10, r, r, r, 0.25);
                }
            } else {
                if (target.m_6844_(EquipmentSlot.HEAD) != ItemStack.f_41583_ && world instanceof Level && !(lvl = world).m_5776_()) {
                    armor = new ItemEntity(lvl, x, y, z2, target.m_6844_(EquipmentSlot.HEAD));
                    armor.m_32010_(10);
                    lvl.m_7967_((Entity)armor);
                }
                if (target.m_6844_(EquipmentSlot.CHEST) != ItemStack.f_41583_ && world instanceof Level && !(lvl = world).m_5776_()) {
                    armor = new ItemEntity(lvl, x, y, z2, target.m_6844_(EquipmentSlot.CHEST));
                    armor.m_32010_(10);
                    lvl.m_7967_((Entity)armor);
                }
                if (target.m_6844_(EquipmentSlot.LEGS) != ItemStack.f_41583_ && world instanceof Level && !(lvl = world).m_5776_()) {
                    armor = new ItemEntity(lvl, x, y, z2, target.m_6844_(EquipmentSlot.LEGS));
                    armor.m_32010_(10);
                    lvl.m_7967_((Entity)armor);
                }
                if (target.m_6844_(EquipmentSlot.FEET) != ItemStack.f_41583_ && world instanceof Level && !(lvl = world).m_5776_()) {
                    armor = new ItemEntity(lvl, x, y, z2, target.m_6844_(EquipmentSlot.FEET));
                    armor.m_32010_(10);
                    lvl.m_7967_((Entity)armor);
                }
            }
            target.m_5496_(SoundEvents.f_11681_, 1.0f, 1.0f);
            target.m_146870_();
            if (!(world instanceof Level) || (lvl = world).m_5776_()) continue;
            armor = new ItemEntity(lvl, x, y, z2, new ItemStack((ItemLike)Items.f_42650_));
            armor.m_32010_(10);
            lvl.m_7967_((Entity)armor);
        }
        if (this.m_6084_()) {
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            if (!this.f_19853_.m_5776_() && this.f_19853_.m_46461_() && this.f_19853_.m_46861_(new BlockPos(x, y, z))) {
                this.m_5496_((SoundEvent)SupernaturalModSounds.GHOST_POOF.get(), 1.0f, 1.0f);
                this.m_146870_();
                Level z2 = this.f_19853_;
                if (z2 instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)z2;
                    double r = this.f_19796_.m_188583_() * 0.02;
                    lvl.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 10, r, r, r, 0.25);
                }
            }
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        for (LivingEntity target : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.56))) {
            Monster billy;
            if (!(target instanceof Player) && !(target instanceof Animal) && (!(target instanceof Monster) || !(billy = (Monster)target).m_21532_())) continue;
            this.m_21530_();
        }
        return retval;
    }

    protected float m_6121_() {
        return 0.45f;
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.2);
        builder = builder.m_22268_(Attributes.f_22276_, 12.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.15);
        builder = builder.m_22268_(Attributes.f_22280_, 0.35);
        return builder;
    }

    static class SpookAttackSelector
    implements Predicate<LivingEntity> {
        private final SpookyEntity ghost;

        public SpookAttackSelector(SpookyEntity source) {
            this.ghost = source;
        }

        @Override
        public boolean test(@Nullable LivingEntity target) {
            if (!(target.m_21023_((MobEffect)SupernaturalModMobEffects.POSSESSION.get()) || target.m_21023_(MobEffects.f_19619_) || target.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)new ResourceLocation("supernatural:spook_no_possess"))))) {
                return target instanceof Animal || target instanceof Monster || target instanceof Slime;
            }
            return false;
        }
    }
}

