/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.salju.supernatural.init.SupernaturalModEnchantments;
import net.salju.supernatural.init.SupernaturalModEntities;
import net.salju.supernatural.init.SupernaturalModSounds;

public class VampireEntity
extends AbstractIllager {
    static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = pip -> pip == Difficulty.NORMAL || pip == Difficulty.HARD;

    public VampireEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<VampireEntity>)((EntityType)SupernaturalModEntities.VAMPIRE.get()), world);
    }

    public VampireEntity(EntityType<VampireEntity> type, Level world) {
        super(type, world);
        this.m_21530_();
        this.f_21364_ = 8;
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new VampireBreakDoorGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(3, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8024_() {
        if (!this.m_21525_() && GoalUtils.m_26894_((Mob)this)) {
            boolean flag = ((ServerLevel)this.f_19853_).m_8843_(this.m_20183_());
            ((GroundPathNavigation)this.m_21573_()).m_26477_(flag);
        }
        super.m_8024_();
    }

    public void m_8107_() {
        boolean flag = this.m_21527_();
        if (flag) {
            this.m_20254_(8);
            this.m_6469_(new DamageSource("vampire.sun").m_19380_(), 4.0f);
        }
        super.m_8107_();
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_5912_()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    public MobType m_6336_() {
        return MobType.f_21643_;
    }

    public boolean m_7307_(Entity ally) {
        if (super.m_7307_(ally)) {
            return true;
        }
        if (ally instanceof LivingEntity && ((LivingEntity)ally).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && ally.m_5647_() == null;
        }
        return false;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_7895_(int imp, boolean boop) {
        Raid raid = this.m_37885_();
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)SupernaturalModSounds.VAMPIRE_IDLE.get();
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)SupernaturalModSounds.VAMPIRE_HURT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)SupernaturalModSounds.VAMPIRE_DEATH.get();
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)SupernaturalModSounds.VAMPIRE_CELEBRATE.get();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        ItemStack sword = new ItemStack((ItemLike)Items.f_42383_);
        sword.m_41764_(1);
        if (Math.random() >= 0.9) {
            sword.m_41663_((Enchantment)SupernaturalModEnchantments.LEECHING.get(), 2);
        } else if (Math.random() >= 0.8) {
            sword.m_41663_((Enchantment)SupernaturalModEnchantments.LEECHING.get(), 1);
        }
        this.m_21008_(InteractionHand.MAIN_HAND, sword);
        return retval;
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.m_5912_()) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1200, 0, false, false));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 1200, 0, false, false));
        }
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22277_, 12.0);
        builder = builder.m_22268_(Attributes.f_22276_, 24.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        return builder;
    }

    static class VampireBreakDoorGoal
    extends BreakDoorGoal {
        public VampireBreakDoorGoal(Mob vampy) {
            super(vampy, 6, DOOR_BREAKING_PREDICATE);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8045_() {
            VampireEntity vampire = (VampireEntity)this.f_25189_;
            return vampire.m_37886_() && super.m_8045_();
        }

        public boolean m_8036_() {
            VampireEntity vampire = (VampireEntity)this.f_25189_;
            return vampire.m_37886_() && vampire.f_19796_.m_188503_(VampireBreakDoorGoal.m_186073_((int)10)) == 0 && super.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.f_25189_.m_21310_(0);
        }
    }
}

