/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.client.renderer.entity.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.vulp.tomes.client.renderer.RenderTypes;
import com.vulp.tomes.entities.SpectralSteedEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.HorseModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;

@OnlyIn(value=Dist.CLIENT)
public class SpectralSteedRenderer<T extends SpectralSteedEntity>
extends MobRenderer<T, HorseModel<T>> {
    private static final ResourceLocation SPECTRAL_STEED_TEXTURE = new ResourceLocation("tomes", "textures/entity/spectral_steed.png");
    private static final ResourceLocation SPECTRAL_STEED_FADE_TEXTURE = new ResourceLocation("tomes", "textures/entity/spectral_steed_fade.png");

    public SpectralSteedRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new HorseModel(0.0f), 0.0f);
    }

    public ResourceLocation getEntityTexture(T entity) {
        if (((SpectralSteedEntity)((Object)entity)).getFade()) {
            return SPECTRAL_STEED_FADE_TEXTURE;
        }
        return ((SpectralSteedEntity)((Object)entity)).getFade() ? SPECTRAL_STEED_FADE_TEXTURE : SPECTRAL_STEED_TEXTURE;
    }

    public void render(T entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (!entityIn.func_82150_aj()) {
            if (((SpectralSteedEntity)((Object)entityIn)).getFade()) {
                packedLightIn = 0xF000F0;
            }
            super.func_225623_a_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    protected RenderType func_230496_a_(T entity, boolean flag1, boolean flag2, boolean flag3) {
        return RenderTypes.getSpectral(this.getEntityTexture(entity), flag3);
    }

    public static class RenderFactory
    implements IRenderFactory<SpectralSteedEntity> {
        public EntityRenderer<? super SpectralSteedEntity> createRenderFor(EntityRendererManager manager) {
            return new SpectralSteedRenderer(manager);
        }
    }
}

