/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.client.renderer.entity.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.vulp.tomes.client.renderer.entity.models.TamedSpiderModel;
import com.vulp.tomes.entities.TamedSpiderEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.AbstractEyesLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;

@OnlyIn(value=Dist.CLIENT)
public class TamedSpiderRenderer<T extends TamedSpiderEntity>
extends MobRenderer<T, TamedSpiderModel<T>> {
    private static final ResourceLocation TAMED_SPIDER_TEXTURE = new ResourceLocation("tomes", "textures/entity/tamed_spider.png");
    private static final RenderType RENDER_TYPE = RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("tomes", "textures/entity/tamed_spider_eyes.png"));

    public TamedSpiderRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new TamedSpiderModel(), 0.8f);
        this.func_177094_a((LayerRenderer)new TamedSpiderEyesLayer(this));
    }

    public ResourceLocation getEntityTexture(T entity) {
        return TAMED_SPIDER_TEXTURE;
    }

    protected float getDeathMaxRotation(T entityLivingBaseIn) {
        return 180.0f;
    }

    public static class RenderFactory
    implements IRenderFactory<TamedSpiderEntity> {
        public EntityRenderer<? super TamedSpiderEntity> createRenderFor(EntityRendererManager manager) {
            return new TamedSpiderRenderer(manager);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TamedSpiderEyesLayer<T extends TamedSpiderEntity, M extends TamedSpiderModel<T>>
    extends AbstractEyesLayer<T, M> {
        public TamedSpiderEyesLayer(IEntityRenderer<T, M> rendererIn) {
            super(rendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(this.func_225636_a_());
            float color = entity.func_110143_aJ() / entity.func_110138_aP();
            ((TamedSpiderModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.field_229196_a_, color, color, color, 1.0f);
        }

        public RenderType func_225636_a_() {
            return RENDER_TYPE;
        }
    }
}

