/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.enchantments;

import com.vulp.tomes.spells.SpellIndex;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;

public class TomeEnchantment
extends Enchantment {
    private static final EquipmentSlotType[] SLOTS = new EquipmentSlotType[0];
    private final SpellIndex spellIndex;
    private final boolean isRare;
    private final boolean isActive;

    public TomeEnchantment(SpellIndex spellIndex, EnchantmentType enchantmentType) {
        super(spellIndex.getSpell().getRarity(), enchantmentType, SLOTS);
        this.spellIndex = spellIndex;
        this.isRare = spellIndex.getSpell().isRare();
        this.isActive = spellIndex.getSpell().isActive();
    }

    public boolean isRare() {
        return this.isRare;
    }

    public SpellIndex getSpellIndex() {
        return this.spellIndex;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int func_77321_a(int enchantmentLevel) {
        if (this.isActive()) {
            return 30;
        }
        return 3;
    }

    public int func_223551_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + 50;
    }

    protected boolean func_77326_a(Enchantment ench) {
        if (ench instanceof TomeEnchantment && this.isActive() && ((TomeEnchantment)ench).isActive()) {
            return false;
        }
        return super.func_77326_a(ench);
    }

    public boolean func_92089_a(ItemStack stack) {
        return super.func_92089_a(stack) && !this.spellIndex.getSpell().isDisabled();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return super.canApplyAtEnchantingTable(stack) && !this.spellIndex.getSpell().isDisabled();
    }

    public boolean func_230310_i_() {
        return super.func_230310_i_() && !this.spellIndex.getSpell().isDisabled();
    }

    public boolean func_185261_e() {
        return this.isRare() || super.func_185261_e();
    }
}

