/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.entities;

import com.vulp.tomes.init.ParticleInit;
import com.vulp.tomes.network.TomesPacketHandler;
import com.vulp.tomes.network.messages.ServerOpenHorseInventoryMessage;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class SpectralSteedEntity
extends HorseEntity {
    private int regenTimer = 35;
    public int lifeTimer = 12000;
    private boolean fade = false;
    private int fadeTimer = 17;
    private int fadeTimerMax = 17;

    public SpectralSteedEntity(EntityType<? extends HorseEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_110234_j(true);
        this.field_110296_bG.func_70299_a(0, new ItemStack((IItemProvider)Items.field_151141_av));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorseEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0, AbstractHorseEntity.class));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.func_205714_dM();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("LifeTime", this.lifeTimer);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.lifeTimer = compound.func_74764_b("LifeTime") ? compound.func_74762_e("LifeTime") : 12000;
    }

    public void func_70636_d() {
        super.func_70636_d();
        boolean flag = false;
        if (!this.field_70170_p.field_72995_K) {
            if (this.regenTimer <= 0) {
                this.func_70691_i(1.0f);
                this.regenTimer = 35;
            } else {
                --this.regenTimer;
            }
        } else {
            flag = true;
        }
        if (this.lifeTimer <= 0) {
            this.func_70106_y();
        } else {
            if (this.lifeTimer <= 200 && flag) {
                if (this.fadeTimer <= 0) {
                    this.fade = !this.fade;
                    this.fadeTimer = this.fadeTimerMax;
                    if (this.fadeTimerMax > 2) {
                        --this.fadeTimerMax;
                    }
                } else {
                    --this.fadeTimer;
                }
                this.field_70170_p.func_195594_a((IParticleData)ParticleInit.spectral_steed_despawn, this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 2.0f), this.func_226281_cx_(), (double)this.func_145782_y(), 0.0, 0.0);
            } else {
                this.field_70170_p.func_195594_a((IParticleData)ParticleInit.spirit_flame, this.func_226282_d_(0.65), this.func_226279_cv_(), this.func_226287_g_(0.65), 0.0, 0.0, 0.0);
            }
            --this.lifeTimer;
        }
    }

    public void func_110199_f(PlayerEntity player) {
        TomesPacketHandler.instance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new ServerOpenHorseInventoryMessage());
    }

    public void saddleUp() {
        this.field_110296_bG.func_70299_a(0, new ItemStack((IItemProvider)Items.field_151141_av));
    }

    public void func_70645_a(DamageSource cause) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)cause)) {
            return;
        }
        if (!this.field_70128_L && !this.field_70729_aU) {
            Entity entity = cause.func_76346_g();
            LivingEntity livingentity = this.func_94060_bK();
            if (this.field_70744_aE >= 0 && livingentity != null) {
                livingentity.func_191956_a((Entity)this, this.field_70744_aE, cause);
            }
            if (this.func_70608_bn()) {
                this.func_213366_dy();
            }
            this.field_70729_aU = true;
            this.func_110142_aN().func_94549_h();
            if (this.field_70170_p instanceof ServerWorld) {
                if (entity != null) {
                    entity.func_241847_a((ServerWorld)this.field_70170_p, (LivingEntity)this);
                }
                this.func_226298_f_(livingentity);
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_213301_b(Pose.DYING);
        }
    }

    protected float func_110267_cL() {
        return 20.0f;
    }

    protected double func_110245_cM() {
        return 0.7;
    }

    protected double func_110203_cN() {
        return 0.32;
    }

    public ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        if (!this.func_70631_g_() && !this.func_184207_aI()) {
            this.func_110237_h(playerIn);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return ActionResultType.FAIL;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        return false;
    }

    public boolean getFade() {
        return this.fade;
    }
}

