/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.entities;

import com.vulp.tomes.network.TomesPacketHandler;
import com.vulp.tomes.network.messages.ServerSpiderFallMessage;
import com.vulp.tomes.pathfinding.BetterClimberPathNavigator;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;

public class TamedSpiderEntity
extends TameableEntity
implements IAngerable {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(TamedSpiderEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> ANGER_TIME = EntityDataManager.func_187226_a(TamedSpiderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final RangedInteger ANGER_TIME_RANGE = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private UUID field_234231_bH_;

    public TamedSpiderEntity(EntityType<? extends TameableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, arg_0 -> ((TamedSpiderEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(5, (Goal)new ResetAngerGoal((MobEntity)this, true));
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233821_d_, 0.3);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
        this.field_70180_af.func_187214_a(ANGER_TIME, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.func_233682_c_(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (!this.field_70170_p.field_72995_K) {
            this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
        }
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new BetterClimberPathNavigator((MobEntity)this, worldIn);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected float func_70599_aP() {
        return 1.0f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
            if (!this.func_70909_n()) {
                this.func_70106_y();
            }
        }
    }

    protected boolean func_230282_cS_() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public void func_213295_a(BlockState state, Vector3d motionMultiplierIn) {
        if (!state.func_203425_a(Blocks.field_196553_aF)) {
            super.func_213295_a(state, motionMultiplierIn);
        }
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == Effects.field_76436_u) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((LivingEntity)this, potioneffectIn);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.65f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        this.func_233687_w_(false);
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_233637_b_(Attributes.field_233823_f_)));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(26.0);
            this.func_70606_j(26.0f);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(16.0);
        }
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(4.0);
    }

    public ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (this.field_70170_p.field_72995_K) {
            boolean flag = this.func_152114_e((LivingEntity)playerIn) || !this.func_233678_J__();
            return flag ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        if (item.func_219971_r() && item.func_219967_s().func_221467_c() && this.func_110143_aJ() < this.func_110138_aP()) {
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.func_70691_i(item.func_219967_s().func_221466_a());
            return ActionResultType.SUCCESS;
        }
        ActionResultType actionresulttype = super.func_230254_b_(playerIn, hand);
        if ((!actionresulttype.func_226246_a_() || this.func_70631_g_()) && this.func_152114_e((LivingEntity)playerIn)) {
            this.func_233687_w_(!this.func_233685_eM_());
            this.field_70703_bu = false;
            ((BetterClimberPathNavigator)this.field_70699_by).clearPathForSitting();
            this.func_70624_b(null);
            return ActionResultType.SUCCESS;
        }
        return actionresulttype;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (distance > 3.0f) {
            Vector3d vec = this.func_213303_ch();
            TomesPacketHandler.instance.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ServerSpiderFallMessage(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
        }
        return super.func_225503_b_(distance, 0.0f);
    }

    public int func_70646_bf() {
        return this.func_233684_eK_() ? 20 : super.func_70646_bf();
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public int func_70641_bl() {
        return 0;
    }

    public int func_230256_F__() {
        return (Integer)this.field_70180_af.func_187225_a(ANGER_TIME);
    }

    public void func_230260_a__(int time) {
        this.field_70180_af.func_187227_b(ANGER_TIME, (Object)time);
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGER_TIME_RANGE.func_233018_a_(this.field_70146_Z));
    }

    @Nullable
    public UUID func_230257_G__() {
        return this.field_234231_bH_;
    }

    public void func_230259_a_(@Nullable UUID target) {
        this.field_234231_bH_ = target;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        return false;
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity) && !(target instanceof GhastEntity)) {
            if (target instanceof WolfEntity) {
                WolfEntity wolfentity = (WolfEntity)target;
                return !wolfentity.func_70909_n() || wolfentity.func_70902_q() != owner;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof TameableEntity) || !((TameableEntity)target).func_70909_n();
        }
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_233678_J__() && super.func_184652_a(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, (double)(0.6f * this.func_70047_e()), (double)(this.func_213311_cf() * 0.4f));
    }

    public void func_233687_w_(boolean p_233687_1_) {
        if (p_233687_1_) {
            this.field_70699_by.func_188554_j();
        }
        super.func_233687_w_(p_233687_1_);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        return null;
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(TamedSpiderEntity spider) {
            super((CreatureEntity)spider, 1.0, true);
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }
    }
}

