/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.entities.ai;

import com.vulp.tomes.Tomes;
import com.vulp.tomes.init.EffectInit;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.world.World;

public class MindBendFollowGoal
extends Goal {
    private final MobEntity mobEntity;
    private LivingEntity player;
    private final World world;
    private final double followSpeed;
    private final PathNavigator navigator;
    private int timeToRecalcPath;
    private final float maxDist;
    private final float minDist;
    private float oldWaterCost;

    public MindBendFollowGoal(MobEntity mobEntity, double speed, float minDist, float maxDist) {
        this.mobEntity = mobEntity;
        this.world = mobEntity.field_70170_p;
        this.followSpeed = speed;
        this.navigator = mobEntity.func_70661_as();
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(mobEntity.func_70661_as() instanceof GroundPathNavigator) && !(mobEntity.func_70661_as() instanceof FlyingPathNavigator)) {
            Tomes.LOGGER.error("Unsupported mob navigator for MindBendFollowGoal! Effect may act odd.");
        }
    }

    @Nullable
    public PlayerEntity getPlayer(World world) {
        CompoundNBT nbt = this.mobEntity.getPersistentData();
        return nbt.func_186855_b("PlayerFollowingUUID") ? world.func_217371_b(nbt.func_186857_a("PlayerFollowingUUID")) : null;
    }

    public boolean hasMindBent() {
        return this.mobEntity.func_70644_a(EffectInit.mind_bend);
    }

    public boolean func_75250_a() {
        if (this.hasMindBent()) {
            PlayerEntity livingentity = this.getPlayer(this.world);
            if (livingentity == null) {
                return false;
            }
            if (livingentity.func_175149_v()) {
                return false;
            }
            if (this.mobEntity.func_70068_e((Entity)livingentity) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            this.player = livingentity;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.hasMindBent()) {
            if (this.navigator.func_75500_f()) {
                return false;
            }
            return !(this.mobEntity.func_70068_e((Entity)this.player) <= (double)(this.maxDist * this.maxDist));
        }
        return false;
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mobEntity.func_184643_a(PathNodeType.WATER);
        this.mobEntity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.player = null;
        this.navigator.func_75499_g();
        this.mobEntity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
        CompoundNBT nbt = this.mobEntity.serializeNBT();
        if (nbt.func_186855_b("PlayerFollowingUUID")) {
            nbt.func_82580_o("PlayerFollowingUUID");
        }
    }

    public void func_75246_d() {
        this.mobEntity.func_70671_ap().func_75651_a((Entity)this.player, 10.0f, (float)this.mobEntity.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.mobEntity.func_110167_bD() && !this.mobEntity.func_184218_aH()) {
                this.navigator.func_75497_a((Entity)this.player, this.followSpeed);
            }
        }
    }
}

