/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.entities.projectile;

import com.vulp.tomes.init.EntityInit;
import com.vulp.tomes.init.ParticleInit;
import com.vulp.tomes.network.TomesPacketHandler;
import com.vulp.tomes.network.messages.ServerWitheringStenchParticleMessage;
import net.minecraft.block.AbstractBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class WitheringStenchEntity
extends ProjectileEntity {
    private int lifespan = 20;

    public WitheringStenchEntity(EntityType<? extends WitheringStenchEntity> entityType, World world) {
        super(entityType, world);
    }

    public WitheringStenchEntity(World worldIn, PlayerEntity player) {
        this(EntityInit.withering_stench, worldIn);
        super.func_212361_a((Entity)player);
        this.func_70107_b(player.func_226277_ct_() - (double)(player.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(player.field_70761_aq * ((float)Math.PI / 180))), player.func_226280_cw_() - (double)0.1f, player.func_226281_cx_() + (double)(player.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(player.field_70761_aq * ((float)Math.PI / 180))));
        this.lifespan = 20;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Vector3d vector3d = this.func_213322_ci();
        RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, arg_0 -> ((WitheringStenchEntity)this).func_230298_a_(arg_0));
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.func_70227_a(raytraceresult);
        }
        double d0 = this.func_226277_ct_() + vector3d.field_72450_a;
        double d1 = this.func_226278_cu_() + vector3d.field_72448_b;
        double d2 = this.func_226281_cx_() + vector3d.field_72449_c;
        this.func_234617_x_();
        if (this.field_70170_p.func_234853_a_(this.func_174813_aQ()).noneMatch(AbstractBlock.AbstractBlockState::func_196958_f)) {
            this.func_70106_y();
        } else if (this.func_203005_aq()) {
            this.func_70106_y();
        } else {
            this.func_213317_d(vector3d.func_186678_a((double)0.99f));
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)-0.06f, 0.0));
            }
            this.func_70107_b(d0, d1, d2);
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleInit.withering_stench, (double)this.func_233580_cy_().func_177958_n(), (double)this.func_233580_cy_().func_177956_o(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        if (this.lifespan > 0) {
            --this.lifespan;
        } else {
            this.func_70106_y();
        }
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        super.func_70186_c(x, y, z, velocity, inaccuracy);
        Vector3d motion = this.func_213322_ci();
        TomesPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new ServerWitheringStenchParticleMessage(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), motion.func_82615_a(), motion.func_82617_b(), motion.func_82616_c()));
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        super.func_213868_a(result);
        Entity entity = this.func_234616_v_();
        Entity target = result.func_216348_a();
        if (entity instanceof LivingEntity && target instanceof LivingEntity) {
            ((LivingEntity)target).func_195064_c(new EffectInstance(Effects.field_82731_v, 200));
        }
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        super.func_230299_a_(result);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

