/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.events;

import com.mojang.datafixers.util.Pair;
import com.vulp.tomes.Tomes;
import com.vulp.tomes.config.TomesConfig;
import com.vulp.tomes.entities.ai.MindBendFollowGoal;
import com.vulp.tomes.entities.ai.NullifyAttackableTargetGoal;
import com.vulp.tomes.init.EffectInit;
import com.vulp.tomes.init.EnchantmentInit;
import com.vulp.tomes.init.ItemInit;
import com.vulp.tomes.init.ParticleInit;
import com.vulp.tomes.inventory.container.WitchMerchantContainer;
import com.vulp.tomes.items.DebugItem;
import com.vulp.tomes.items.TomeItem;
import com.vulp.tomes.network.TomesPacketHandler;
import com.vulp.tomes.network.messages.ServerCropBreakMessage;
import com.vulp.tomes.network.messages.ServerMindBendMessage;
import com.vulp.tomes.network.messages.ServerProjDeflectMessage;
import com.vulp.tomes.util.HealthHandler;
import com.vulp.tomes.util.SpellEnchantUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="tomes", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityEvents {
    private static final HashMap<Entity, Integer> mindbendParticleHandlers = new HashMap();
    private static final List<Pair<LivingEntity, HealthHandler>> healthHandlers = new ArrayList<Pair<LivingEntity, HealthHandler>>();
    private static int slowTickTimer = 10;

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        LivingEntity player = event.getTarget();
        Entity aggressor = event.getEntity();
        if (event.getTarget() instanceof PlayerEntity) {
            if (((Boolean)TomesConfig.covens_rule_enabled.get()).booleanValue() && event.getEntity() instanceof WitchEntity && SpellEnchantUtil.hasEnchant((PlayerEntity)player, EnchantmentInit.covens_rule)) {
                ((WitchEntity)aggressor).func_70624_b(null);
            }
            if (((Boolean)TomesConfig.covens_rule_enabled.get()).booleanValue() && (aggressor instanceof SpiderEntity || aggressor instanceof CreeperEntity || aggressor instanceof ZombieEntity || aggressor instanceof SkeletonEntity) && SpellEnchantUtil.hasEnchant((PlayerEntity)player, EnchantmentInit.rotten_heart)) {
                ((MobEntity)aggressor).func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDropsEvent(LivingDropsEvent event) {
        Entity entity = event.getEntity();
        Random rand = new Random();
        if (entity instanceof WitchEntity) {
            if (rand.nextInt(19) < (Integer)TomesConfig.sweet_heart_droprate.get()) {
                event.getDrops().add(new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_() + entity.func_70033_W(), entity.func_226281_cx_(), new ItemStack((IItemProvider)ItemInit.sweet_heart)));
            }
        } else if (entity instanceof VillagerEntity || entity instanceof AbstractIllagerEntity) {
            if (rand.nextInt(19) < (Integer)TomesConfig.beating_heart_droprate.get()) {
                event.getDrops().add(new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_() + entity.func_70033_W(), entity.func_226281_cx_(), new ItemStack((IItemProvider)ItemInit.beating_heart)));
            }
        } else if (entity instanceof ZombieEntity && rand.nextInt(19) < (Integer)TomesConfig.archaic_heart_droprate.get()) {
            event.getDrops().add(new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_() + entity.func_70033_W(), entity.func_226281_cx_(), new ItemStack((IItemProvider)ItemInit.ancient_heart)));
        }
    }

    @SubscribeEvent
    public static void onLivingDespawnEvent(LivingSpawnEvent.AllowDespawn event) {
        Entity entity = event.getEntity();
        if (entity instanceof WitchEntity && entity.getPersistentData().func_74764_b("Offers")) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        PlayerEntity player = event.getPlayer();
        Entity entity = event.getTarget();
        World world = player.field_70170_p;
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (item instanceof TomeItem) {
            if (((Boolean)TomesConfig.beast_tamer_enabled.get()).booleanValue() && entity instanceof AbstractHorseEntity) {
                if (SpellEnchantUtil.hasEnchant(player, EnchantmentInit.beast_tamer)) {
                    Hand hand = Hand.OFF_HAND;
                    if (stack == player.func_184614_ca()) {
                        hand = Hand.MAIN_HAND;
                    }
                    item.func_111207_a(stack, player, (LivingEntity)entity, hand);
                    item.func_77659_a(world, player, hand);
                }
            } else if (((Boolean)TomesConfig.covens_rule_enabled.get()).booleanValue() && entity instanceof WitchEntity && SpellEnchantUtil.hasEnchant(player, EnchantmentInit.covens_rule)) {
                MerchantOffers offers = WitchMerchantContainer.getMerchantOffers(entity);
                if (player.func_184600_cs() == Hand.MAIN_HAND) {
                    player.func_195066_a(Stats.field_188074_H);
                }
                if (!world.field_72995_K && !offers.isEmpty()) {
                    MerchantOffers merchantoffers;
                    CompoundNBT nbt = entity.getPersistentData();
                    nbt.func_186854_a("Customer", player.func_110124_au());
                    OptionalInt optionalint = player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, player2) -> new WitchMerchantContainer(id, playerInventory, (WitchEntity)entity), entity.func_145748_c_()));
                    if (optionalint.isPresent() && !(merchantoffers = WitchMerchantContainer.getMerchantOffers(entity)).isEmpty()) {
                        player.func_213818_a(optionalint.getAsInt(), merchantoffers, 0, 0, false, false);
                    }
                }
            }
        }
        if (item instanceof DebugItem) {
            ((DebugItem)item).debugEntity(world, entity, stack);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        if (((Boolean)TomesConfig.advantageous_growth_enabled.get()).booleanValue() && SpellEnchantUtil.hasEnchant(player, EnchantmentInit.advantageous_growth) && state.func_177230_c() instanceof CropsBlock && ((CropsBlock)state.func_177230_c()).func_185525_y(state) && !player.func_184812_l_()) {
            Block.func_220075_c((BlockState)state, (World)world, (BlockPos)pos);
            TomesPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> (Chunk)world.func_217349_x(pos)), (Object)new ServerCropBreakMessage(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        }
    }

    @SubscribeEvent
    public static void projHitEvent(ProjectileImpactEvent event) {
        Entity proj;
        if (((Boolean)TomesConfig.airy_protection_enabled.get()).booleanValue() && (proj = event.getEntity()) != null) {
            Entity victim;
            Vector3d vector3d1 = proj.func_213303_ch();
            Vector3d vector3d2 = vector3d1.func_178787_e(proj.func_213322_ci());
            RayTraceResult result = event.getRayTraceResult();
            EntityRayTraceResult raytrace = ProjectileHelper.func_221269_a((World)event.getEntity().field_70170_p, (Entity)proj, (Vector3d)vector3d1, (Vector3d)vector3d2, (AxisAlignedBB)proj.func_174813_aQ().func_216361_a(proj.func_213322_ci()).func_186662_g(1.0), i -> true);
            if (result != null && raytrace != null && result.func_216346_c() == RayTraceResult.Type.ENTITY && (victim = raytrace.func_216348_a()) instanceof PlayerEntity && SpellEnchantUtil.hasEnchant((PlayerEntity)victim, EnchantmentInit.airy_protection) && proj instanceof ProjectileEntity && new Random().nextBoolean() && !proj.field_70170_p.field_72995_K) {
                TomesPacketHandler.instance.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> victim), (Object)new ServerProjDeflectMessage(victim.func_145782_y(), proj.func_145782_y()));
                Vector3d vec = proj.func_213322_ci();
                Vector3d vec2 = vec.func_216371_e();
                try {
                    proj.func_213293_j(vec2.func_82615_a() * 0.75, vec2.func_82617_b() * 0.75, vec2.func_82616_c() * 0.75);
                }
                catch (NoSuchMethodError error) {
                    Tomes.LOGGER.debug("Caught an error typically caused by using multiple projectile deflection methods.");
                    return;
                }
                proj.field_70125_A = MathHelper.func_76142_g((float)(proj.field_70125_A + 180.0f));
                proj.field_70177_z = MathHelper.func_76142_g((float)(proj.field_70177_z + 180.0f));
                if (proj instanceof DamagingProjectileEntity) {
                    DamagingProjectileEntity damageProj = (DamagingProjectileEntity)proj;
                    damageProj.field_70232_b = -damageProj.field_70232_b * 0.75;
                    damageProj.field_70233_c = -damageProj.field_70233_c * 0.75;
                    damageProj.field_70230_d = -damageProj.field_70230_d * 0.75;
                }
                ((ProjectileEntity)proj).func_212361_a(victim);
                proj.field_70133_I = true;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHealed(LivingHealEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.func_70644_a(EffectInit.leaden_veins)) {
            float amount = event.getAmount();
            if (amount > 2.0f) {
                event.setAmount(amount - 2.0f);
            } else if (amount > 1.0f) {
                event.setAmount(amount - 1.0f);
            } else {
                boolean flag = false;
                Optional<Pair> optional = healthHandlers.stream().filter(pair -> pair.getFirst() == entity).findFirst();
                if (optional.isPresent()) {
                    HealthHandler handler = (HealthHandler)optional.get().getSecond();
                    if (handler != null) {
                        if (handler.shouldHeal()) {
                            event.setAmount(amount);
                        } else {
                            event.setAmount(0.0f);
                        }
                        handler.toggleHeal();
                    } else {
                        flag = true;
                    }
                } else {
                    flag = true;
                }
                if (flag) {
                    healthHandlers.add((Pair<LivingEntity, HealthHandler>)new Pair((Object)entity, (Object)new HealthHandler(entity)));
                    event.setAmount(0.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void livingTickEvent(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = (LivingEntity)event.getEntity();
        if (entity != null && entity.getPersistentData().func_74764_b("HexParticle")) {
            CompoundNBT nbt = entity.getPersistentData();
            if (entity.field_70170_p.field_72995_K && nbt.func_74767_n("HexParticle")) {
                mindbendParticleHandlers.putIfAbsent((Entity)entity, 7);
            } else {
                if (slowTickTimer == 0 && entity instanceof MobEntity && nbt.func_186855_b("PlayerFollowingUUID") && entity.func_70644_a(EffectInit.mind_bend)) {
                    MobEntity mobEntity = (MobEntity)entity;
                    if (mobEntity.field_70714_bg.field_220892_d.stream().noneMatch(pGoal -> pGoal.func_220772_j() instanceof MindBendFollowGoal)) {
                        mobEntity.field_70714_bg.func_75776_a(1, (Goal)new MindBendFollowGoal(mobEntity, 1.0, 5.0f, 2.0f));
                        mobEntity.field_70715_bh.func_75776_a(0, (Goal)new NullifyAttackableTargetGoal(mobEntity, false));
                    }
                }
                TomesPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new ServerMindBendMessage(entity.func_145782_y(), nbt.func_74767_n("HexParticle")));
            }
        }
    }

    @SubscribeEvent
    public static void livingDeathEvent(LivingDeathEvent event) {
    }

    @SubscribeEvent
    public static void entityLeaveWorldEvent(EntityLeaveWorldEvent event) {
        mindbendParticleHandlers.clear();
    }

    @SubscribeEvent
    public static void serverTickEvent(TickEvent.ServerTickEvent event) {
        if (!healthHandlers.isEmpty()) {
            healthHandlers.removeIf(pair -> pair.getFirst() == null || pair.getSecond() == null || ((HealthHandler)pair.getSecond()).readyToRemove());
            healthHandlers.forEach(pair -> ((HealthHandler)pair.getSecond()).tick());
        }
        slowTickTimer = slowTickTimer < 1 ? 20 : --slowTickTimer;
    }

    @SubscribeEvent
    public static void clientTickEvent(TickEvent.ClientTickEvent event) {
        ArrayList<Entity> removalList = new ArrayList<Entity>(Collections.emptyList());
        if (!mindbendParticleHandlers.isEmpty()) {
            mindbendParticleHandlers.keySet().removeIf(entity -> entity == null || entity.field_70128_L);
            mindbendParticleHandlers.forEach((entity, timer) -> {
                if (!entity.getPersistentData().func_74767_n("HexParticle") || entity.field_70128_L) {
                    removalList.add((Entity)entity);
                } else if (timer <= 0) {
                    entity.field_70170_p.func_195594_a((IParticleData)ParticleInit.hex, entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_213302_cg() + 0.5, entity.func_226281_cx_(), (double)entity.func_145782_y(), 0.0, 0.0);
                    mindbendParticleHandlers.replace((Entity)entity, 7);
                } else {
                    mindbendParticleHandlers.replace((Entity)entity, timer - 1);
                }
            });
        }
        removalList.forEach(mindbendParticleHandlers::remove);
    }

    @SubscribeEvent
    public static void livingFallEvent(LivingFallEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).func_70644_a(EffectInit.light_footed)) {
            event.setDamageMultiplier(0.0f);
            Random rand = new Random();
            World world = entity.field_70170_p;
            if (world.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197598_I, entity.func_226277_ct_(), entity.func_226278_cu_() + 0.05, entity.func_226281_cx_(), (double)(rand.nextFloat() - rand.nextFloat()) * 0.15, (double)(rand.nextFloat() - rand.nextFloat()) * 0.05, (double)(rand.nextFloat() - rand.nextFloat()) * 0.15);
                }
            }
        }
    }

    @SubscribeEvent
    public static void expEvent(PlayerXpEvent.XpChange event) {
        if (((Boolean)TomesConfig.dying_knowledge_enabled.get()).booleanValue() && SpellEnchantUtil.hasEnchant(event.getPlayer(), EnchantmentInit.dying_knowledge)) {
            event.setAmount((int)((float)event.getAmount() * 1.5f));
        }
    }
}

