/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.events;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.vulp.tomes.config.TomesConfig;
import com.vulp.tomes.enchantments.EnchantClueHolder;
import com.vulp.tomes.init.EnchantmentInit;
import com.vulp.tomes.init.ItemInit;
import com.vulp.tomes.items.TomeItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.EnchantmentContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tomes", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RenderEvents {
    private static boolean HOOK_TOGGLE = false;

    @SubscribeEvent
    public static void onRenderHandEvent(RenderHandEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof TomeItem && stack.func_77948_v()) {
            Minecraft minecraft = Minecraft.func_71410_x();
            TomeItem tome = (TomeItem)stack.func_77973_b();
            ItemStack newStack = stack.func_77946_l();
            if (tome == ItemInit.archaic_tome) {
                newStack = new ItemStack((IItemProvider)ItemInit.archaic_tome_open);
            } else if (tome == ItemInit.living_tome) {
                newStack = new ItemStack((IItemProvider)ItemInit.living_tome_open);
            } else if (tome == ItemInit.cursed_tome) {
                newStack = new ItemStack((IItemProvider)ItemInit.cursed_tome_open);
            }
            minecraft.func_175597_ag().func_228405_a_((AbstractClientPlayerEntity)minecraft.field_71439_g, event.getPartialTicks(), event.getInterpolatedPitch(), event.getHand(), event.getSwingProgress(), newStack, event.getEquipProgress(), event.getMatrixStack(), event.getBuffers(), event.getLight());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderTooltipEvent(RenderTooltipEvent.Pre event) {
        if (HOOK_TOGGLE) {
            HOOK_TOGGLE = false;
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (player != null) {
            Screen screen;
            boolean hasTome;
            PlayerInventory inventory = player.field_71071_by;
            boolean bl = hasTome = inventory != null && Arrays.stream(new ItemStack[]{inventory.func_70448_g(), (ItemStack)inventory.field_184439_c.get(0)}).anyMatch(item -> item.func_77973_b() instanceof TomeItem && EnchantmentHelper.func_82781_a((ItemStack)item).containsKey(EnchantmentInit.linguist));
            if (((Boolean)TomesConfig.linguist_enabled.get()).booleanValue() && hasTome && (screen = minecraft.field_71462_r) instanceof ContainerScreen && ((ContainerScreen)screen).func_212873_a_() instanceof EnchantmentContainer) {
                ContainerScreen containerScreen = (ContainerScreen)screen;
                EnchantmentContainer container = (EnchantmentContainer)containerScreen.func_212873_a_();
                EnchantClueHolder clueHolder = EnchantClueHolder.decodeClues(container.field_185001_h);
                for (int j = 0; j < 3; ++j) {
                    List<Pair<Enchantment, Integer>> clueList = clueHolder.getData(j);
                    ArrayList list = Lists.newArrayList();
                    int k = 0;
                    int i1 = j + 1;
                    ItemStack stack = container.field_75168_e.func_70301_a(0);
                    if (!RenderEvents.isPointInRegion(60, 14 + 19 * j, 108, 17, event.getX(), event.getY(), containerScreen.getGuiLeft(), containerScreen.getGuiTop()) || clueList.size() <= 0 || stack.func_190926_b() || stack.func_77948_v() || !stack.func_77956_u()) continue;
                    for (Pair<Enchantment, Integer> clue : clueList) {
                        if (clue.getFirst() != null) {
                            list.add(RenderEvents.getDisplayName((Enchantment)clue.getFirst(), (Integer)clue.getSecond()));
                            continue;
                        }
                        list.add(new StringTextComponent(". . .").func_240699_a_(TextFormatting.AQUA));
                    }
                    if (clueList.isEmpty()) {
                        list.add(new StringTextComponent(""));
                        list.add(new TranslationTextComponent("forge.container.enchant.limitedEnchantability").func_240699_a_(TextFormatting.RED));
                    } else if (!player.field_71075_bZ.field_75098_d) {
                        list.add(StringTextComponent.field_240750_d_);
                        if (player.field_71068_ca < k) {
                            list.add(new TranslationTextComponent("container.enchant.level.requirement", new Object[]{container.field_75167_g[j]}).func_240699_a_(TextFormatting.RED));
                        } else {
                            TranslationTextComponent iformattabletextcomponent = i1 == 1 ? new TranslationTextComponent("container.enchant.lapis.one") : new TranslationTextComponent("container.enchant.lapis.many", new Object[]{i1});
                            list.add(iformattabletextcomponent.func_240699_a_(container.func_178147_e() >= i1 ? TextFormatting.GRAY : TextFormatting.RED));
                            TranslationTextComponent iformattabletextcomponent1 = i1 == 1 ? new TranslationTextComponent("container.enchant.level.one") : new TranslationTextComponent("container.enchant.level.many", new Object[]{i1});
                            list.add(iformattabletextcomponent1.func_240699_a_(TextFormatting.GRAY));
                        }
                    }
                    HOOK_TOGGLE = true;
                    containerScreen.func_243308_b(event.getMatrixStack(), (List)list, event.getX(), event.getY());
                    event.setCanceled(true);
                }
            }
        }
    }

    private static boolean isPointInRegion(int x, int y, int width, int height, double mouseX, double mouseY, int guiLeft, int guiTop) {
        return (mouseX -= (double)guiLeft) >= (double)(x - 1) && mouseX < (double)(x + width + 1) && (mouseY -= (double)guiTop) >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    private static ITextComponent getDisplayName(Enchantment enchantment, int level) {
        TranslationTextComponent iformattabletextcomponent = new TranslationTextComponent(enchantment.func_77320_a());
        if (enchantment.func_190936_d()) {
            iformattabletextcomponent.func_240699_a_(TextFormatting.RED);
        } else {
            iformattabletextcomponent.func_240699_a_(TextFormatting.AQUA);
        }
        if (level != 1 || enchantment.func_77325_b() != 1) {
            iformattabletextcomponent.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("enchantment.level." + level));
        }
        return iformattabletextcomponent;
    }
}

