/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.init;

import com.vulp.tomes.entities.SpectralSteedEntity;
import com.vulp.tomes.entities.TamedSpiderEntity;
import com.vulp.tomes.entities.WildWolfEntity;
import com.vulp.tomes.entities.projectile.WitheringStenchEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tomes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityInit {
    public static final EntityType<WildWolfEntity> wild_wolf = EntityInit.createEntity(WildWolfEntity::new, EntityClassification.CREATURE, "wild_wolf", 0.6f, 0.85f, 10);
    public static final EntityType<TamedSpiderEntity> tamed_spider = EntityInit.createEntity(TamedSpiderEntity::new, EntityClassification.CREATURE, "tamed_spider", 1.4f, 0.9f, 8);
    public static final EntityType<SpectralSteedEntity> spectral_steed = EntityInit.createEntity(SpectralSteedEntity::new, EntityClassification.CREATURE, "spectral_steed", 1.3964844f, 1.6f, 10);
    public static final EntityType<WitheringStenchEntity> withering_stench = EntityInit.createEntity(WitheringStenchEntity::new, EntityClassification.MISC, "withering_stench", 0.25f, 0.25f, 10);

    private static <T extends Entity> EntityType<T> createEntity(EntityType.IFactory<T> factory, EntityClassification entityClassification, String name, float width, float height, int trackingRange) {
        ResourceLocation location = new ResourceLocation("tomes", name);
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)entityClassification).func_220321_a(width, height).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3);
        if (trackingRange != -1) {
            builder.setTrackingRange(trackingRange);
        }
        EntityType entity = builder.func_206830_a(location.toString());
        entity.setRegistryName(location);
        return entity;
    }

    @SubscribeEvent
    public static void setupAttributes(EntityAttributeCreationEvent event) {
        event.put(wild_wolf, WildWolfEntity.func_234233_eS_().func_233813_a_());
        event.put(tamed_spider, TamedSpiderEntity.bakeAttributes().func_233813_a_());
        event.put(spectral_steed, SpectralSteedEntity.func_234237_fg_().func_233813_a_());
    }
}

