/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.items;

import com.mojang.datafixers.util.Pair;
import com.vulp.tomes.enchantments.EnchantmentTypes;
import com.vulp.tomes.enchantments.TomeEnchantment;
import com.vulp.tomes.init.EnchantmentInit;
import com.vulp.tomes.init.ItemInit;
import com.vulp.tomes.items.HiddenDescriptorItem;
import com.vulp.tomes.network.TomesPacketHandler;
import com.vulp.tomes.network.messages.ServerActiveSpellMessage;
import com.vulp.tomes.spells.SpellIndex;
import com.vulp.tomes.spells.active.ActiveSpell;
import com.vulp.tomes.spells.passive.CovensRuleSpell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class TomeItem
extends HiddenDescriptorItem {
    public TomeItem(Item.Properties properties) {
        super(properties);
    }

    public int func_77619_b() {
        return 30;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        EnchantmentType type = enchantment.field_77351_y;
        if (type != EnchantmentType.BREAKABLE) {
            return super.canApplyAtEnchantingTable(stack, enchantment);
        }
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return toRepair.func_77973_b() == ItemInit.archaic_tome && repair.func_77973_b() == ItemInit.ancient_heart || toRepair.func_77973_b() == ItemInit.living_tome && repair.func_77973_b() == ItemInit.beating_heart || toRepair.func_77973_b() == ItemInit.cursed_tome && repair.func_77973_b() == ItemInit.sweet_heart || super.func_82789_a(toRepair, repair);
    }

    @Nullable
    private static SpellIndex getActiveSpell(ItemStack itemStack) {
        CompoundNBT nbt = itemStack.func_196082_o();
        if (nbt.func_74764_b("active")) {
            return SpellIndex.spellIndexFromId(nbt.func_74762_e("active"));
        }
        nbt.func_74768_a("active", -1);
        return null;
    }

    @Nullable
    private static SpellIndex[] getPassiveSpells(ItemStack itemStack) {
        CompoundNBT nbt = itemStack.func_196082_o();
        if (nbt.func_74764_b("passive")) {
            return SpellIndex.spellIndexArrayFromIds(nbt.func_74759_k("passive"));
        }
        nbt.func_74783_a("passive", new int[]{-1});
        return null;
    }

    private static void setActiveSpell(ItemStack itemStack, SpellIndex spellIndex) {
        CompoundNBT nbt = itemStack.func_196082_o();
        nbt.func_74768_a("active", SpellIndex.idFromSpellIndex(spellIndex));
    }

    private static void removeActiveSpell(ItemStack itemStack) {
        CompoundNBT nbt = itemStack.func_196082_o();
        nbt.func_82580_o("active");
    }

    private static void setPassiveSpells(ItemStack itemStack, SpellIndex[] spellIndex) {
        CompoundNBT nbt = itemStack.func_196082_o();
        nbt.func_74783_a("passive", SpellIndex.idArrayFromSpellIndexes(spellIndex));
    }

    private static int getRemainingDurability(ItemStack stack) {
        return stack.func_77958_k() - stack.func_77952_i();
    }

    private static boolean canCast(ItemStack stack) {
        SpellIndex activeSpellIndex = TomeItem.getActiveSpell(stack);
        if (activeSpellIndex != null) {
            ActiveSpell spell = (ActiveSpell)activeSpellIndex.getSpell();
            return !spell.isDisabled() && spell.getSpellCost() < TomeItem.getRemainingDurability(stack);
        }
        return false;
    }

    private static boolean castActiveSpell(World worldIn, ItemStack stack, PlayerEntity playerIn, Hand handIn) {
        SpellIndex activeSpellIndex = TomeItem.getActiveSpell(stack);
        if (activeSpellIndex != null) {
            ActiveSpell spell = (ActiveSpell)activeSpellIndex.getSpell();
            return spell.onCast(worldIn, playerIn, handIn);
        }
        return false;
    }

    private static void setCooldown(ItemStack stack, int ticks) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74768_a("cooldown", ticks);
        nbt.func_74768_a("cooldownTotal", ticks);
    }

    public static int getCooldown(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("cooldown")) {
            return nbt.func_74762_e("cooldown");
        }
        return 0;
    }

    public static int getCooldownMax(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("cooldownTotal")) {
            return nbt.func_74762_e("cooldownTotal");
        }
        return 0;
    }

    private static void reduceCooldown(ItemStack stack, int ticks) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("cooldown") && nbt.func_74762_e("cooldown") > 0) {
            nbt.func_74768_a("cooldown", nbt.func_74762_e("cooldown") - ticks);
        }
    }

    private static boolean onCooldown(ItemStack stack) {
        return TomeItem.getCooldown(stack) > 0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand handIn) {
        SpellIndex activeSpellIndex = TomeItem.getActiveSpell(stack);
        if (activeSpellIndex != null && !activeSpellIndex.getSpell().isDisabled()) {
            ActiveSpell spell = (ActiveSpell)activeSpellIndex.getSpell();
            spell.setTarget((Entity)target);
        }
        return super.func_111207_a(stack, playerIn, target, handIn);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack[] stack = new ItemStack[]{playerIn.func_184586_b(handIn)};
        SpellIndex activeSpellIndex = TomeItem.getActiveSpell(stack[0]);
        if (activeSpellIndex != null && !TomeItem.onCooldown(stack[0])) {
            ActiveSpell spell = (ActiveSpell)activeSpellIndex.getSpell();
            if (!worldIn.field_72995_K && spell != null && TomeItem.canCast(stack[0])) {
                SpellIndex[] index = TomeItem.getPassiveSpells(stack[0]);
                if (index != null && Arrays.stream(index).anyMatch(s -> s.getSpell() instanceof CovensRuleSpell) && spell.getTarget() instanceof WitchEntity) {
                    spell.setTarget(null);
                    return ActionResult.func_226251_d_((Object)stack[0]);
                }
                boolean flag = false;
                if (TomeItem.castActiveSpell(worldIn, stack[0], playerIn, handIn)) {
                    stack[0].func_222118_a(spell.getSpellCost(), (LivingEntity)playerIn, playerEntity -> {
                        stack[0] = new ItemStack((IItemProvider)stack[0].func_77973_b());
                    });
                    TomeItem.setCooldown(stack[0], spell.getCooldown());
                    flag = true;
                }
                TomesPacketHandler.instance.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)playerIn), (Object)new ServerActiveSpellMessage(stack[0], handIn == Hand.MAIN_HAND));
                if (flag) {
                    return ActionResult.func_226248_a_((Object)stack[0]);
                }
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public static void clientCastActiveSpell(World worldIn, PlayerEntity playerIn, ItemStack[] stack, Hand handIn) {
        ActiveSpell spell;
        SpellIndex activeSpellIndex = TomeItem.getActiveSpell(stack[0]);
        if (activeSpellIndex != null && (spell = (ActiveSpell)activeSpellIndex.getSpell()) != null && TomeItem.castActiveSpell(worldIn, stack[0], playerIn, handIn)) {
            stack[0].func_222118_a(spell.getSpellCost(), (LivingEntity)playerIn, playerEntity -> {
                stack[0] = new ItemStack((IItemProvider)stack[0].func_77973_b());
            });
            TomeItem.setCooldown(stack[0], spell.getCooldown());
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        for (ItemStack itemStack : entityIn.func_184214_aD()) {
            SpellIndex[] passiveSpells = TomeItem.getPassiveSpells(stack);
            if (itemStack != stack || passiveSpells == null || passiveSpells.length <= 0) continue;
            for (SpellIndex passiveSpell : passiveSpells) {
                if (passiveSpell.getSpell().isDisabled()) continue;
                passiveSpell.getSpell().tickEvent(worldIn, entityIn);
            }
        }
        SpellIndex activeSpellIndex = TomeItem.getActiveSpell(stack);
        ActiveSpell activeSpell = null;
        if (activeSpellIndex != null) {
            activeSpell = (ActiveSpell)activeSpellIndex.getSpell();
        }
        boolean hasActiveSpell = false;
        ArrayList<SpellIndex> passiveList = new ArrayList<SpellIndex>(Collections.emptyList());
        for (Enchantment enchant : EnchantmentHelper.func_82781_a((ItemStack)stack).keySet()) {
            if (!(enchant instanceof TomeEnchantment)) continue;
            SpellIndex spellIndex = ((TomeEnchantment)enchant).getSpellIndex();
            if (((TomeEnchantment)enchant).isActive()) {
                hasActiveSpell = true;
                if (activeSpell != null && spellIndex.getSpell() == activeSpell) continue;
                TomeItem.setActiveSpell(stack, spellIndex);
                continue;
            }
            passiveList.add(spellIndex);
        }
        if (!passiveList.isEmpty()) {
            SpellIndex[] passiveIndex = new SpellIndex[passiveList.size()];
            passiveList.toArray(passiveIndex);
            TomeItem.setPassiveSpells(stack, passiveIndex);
        } else {
            CompoundNBT nbt = stack.func_196082_o();
            nbt.func_82580_o("passive");
        }
        if (hasActiveSpell) {
            if (activeSpell != null && !activeSpell.isDisabled()) {
                activeSpell.tickEvent(worldIn, entityIn);
            }
        } else {
            this.setDamage(stack, 0);
            TomeItem.removeActiveSpell(stack);
        }
        TomeItem.reduceCooldown(stack, 1);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        Set enchSet = EnchantmentHelper.func_82781_a((ItemStack)stack).keySet();
        enchSet.removeIf(enchantment -> !(enchantment instanceof TomeEnchantment));
        if (enchSet.size() > 0) {
            if (Screen.func_231173_s_()) {
                for (Enchantment enchant : enchSet) {
                    if (!(enchant instanceof TomeEnchantment)) continue;
                    if (!((TomeEnchantment)enchant).getSpellIndex().getSpell().isDisabled()) {
                        Pair formatting = enchant.field_77351_y == EnchantmentTypes.ARCHAIC_TOME ? new Pair((Object)TextFormatting.AQUA, (Object)TextFormatting.BLUE) : (enchant.field_77351_y == EnchantmentTypes.LIVING_TOME ? new Pair((Object)TextFormatting.GREEN, (Object)TextFormatting.DARK_GREEN) : (enchant.field_77351_y == EnchantmentTypes.CURSED_TOME ? new Pair((Object)TextFormatting.RED, (Object)TextFormatting.DARK_RED) : new Pair((Object)TextFormatting.GRAY, (Object)TextFormatting.DARK_GRAY)));
                        TranslationTextComponent active = ((TomeEnchantment)enchant).isActive() ? new TranslationTextComponent("enchantment.tomes.active") : new TranslationTextComponent("enchantment.tomes.passive");
                        tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent(enchant.func_77320_a()).getString() + " - " + active.getString()).func_240701_a_(new TextFormatting[]{(TextFormatting)formatting.getFirst(), TextFormatting.BOLD}));
                        tooltip.add((ITextComponent)EnchantmentInit.TOME_DESCRIPTIONS.get(enchant).func_240699_a_((TextFormatting)formatting.getSecond()));
                        continue;
                    }
                    tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent(enchant.func_77320_a()).getString() + " - DISABLED").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD, TextFormatting.ITALIC}));
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.tomes.hold_shift").func_240701_a_(new TextFormatting[]{TextFormatting.DARK_GRAY, TextFormatting.ITALIC}));
            }
        }
    }
}

