/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.mixin;

import com.mojang.datafixers.util.Pair;
import com.vulp.tomes.enchantments.EnchantmentTypes;
import com.vulp.tomes.enchantments.TomeEnchantment;
import com.vulp.tomes.init.EnchantmentInit;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EnchantedBookItem.class})
public class EnchantedBookItemMixin {
    @OnlyIn(value=Dist.CLIENT)
    @Inject(at={@At(value="TAIL")}, method={"addInformation"})
    public void addInformation(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn, CallbackInfo ci) {
        Set enchSet = EnchantmentHelper.func_82781_a((ItemStack)stack).keySet();
        enchSet.removeIf(enchantment -> !(enchantment instanceof TomeEnchantment));
        if (enchSet.size() > 0) {
            if (enchSet.size() == 1 && enchSet.stream().anyMatch(enchantment -> ((TomeEnchantment)((Object)enchantment)).getSpellIndex().getSpell().isDisabled())) {
                Enchantment[] enchantments = enchSet.toArray(new Enchantment[0]);
                tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent(enchantments[0].func_77320_a()).getString() + " - DISABLED").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD, TextFormatting.ITALIC}));
            } else if (Screen.func_231173_s_()) {
                for (Enchantment enchant : enchSet) {
                    if (!(enchant instanceof TomeEnchantment)) continue;
                    if (!((TomeEnchantment)enchant).getSpellIndex().getSpell().isDisabled()) {
                        TranslationTextComponent spell;
                        Pair formatting;
                        if (enchant.field_77351_y == EnchantmentTypes.ARCHAIC_TOME) {
                            formatting = new Pair((Object)TextFormatting.AQUA, (Object)TextFormatting.BLUE);
                            spell = new TranslationTextComponent("enchantment.tomes.archaic_spell");
                        } else if (enchant.field_77351_y == EnchantmentTypes.LIVING_TOME) {
                            formatting = new Pair((Object)TextFormatting.GREEN, (Object)TextFormatting.DARK_GREEN);
                            spell = new TranslationTextComponent("enchantment.tomes.living_spell");
                        } else if (enchant.field_77351_y == EnchantmentTypes.CURSED_TOME) {
                            formatting = new Pair((Object)TextFormatting.RED, (Object)TextFormatting.DARK_RED);
                            spell = new TranslationTextComponent("enchantment.tomes.cursed_spell");
                        } else {
                            formatting = new Pair((Object)TextFormatting.GRAY, (Object)TextFormatting.DARK_GRAY);
                            spell = new StringTextComponent("");
                        }
                        TranslationTextComponent active = ((TomeEnchantment)enchant).isActive() ? new TranslationTextComponent("enchantment.tomes.active") : new TranslationTextComponent("enchantment.tomes.passive");
                        tooltip.add((ITextComponent)new TranslationTextComponent(enchant.func_77320_a()).func_240701_a_(new TextFormatting[]{(TextFormatting)formatting.getFirst(), TextFormatting.BOLD}));
                        tooltip.add((ITextComponent)new StringTextComponent("[ " + spell.getString() + active.getString() + " ]").func_240701_a_(new TextFormatting[]{(TextFormatting)formatting.getFirst(), TextFormatting.ITALIC}));
                        tooltip.add((ITextComponent)EnchantmentInit.TOME_DESCRIPTIONS.get(enchant).func_240699_a_((TextFormatting)formatting.getSecond()));
                        continue;
                    }
                    tooltip.add((ITextComponent)new StringTextComponent(new TranslationTextComponent(enchant.func_77320_a()).getString() + " - DISABLED").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD, TextFormatting.ITALIC}));
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.tomes.hold_shift").func_240701_a_(new TextFormatting[]{TextFormatting.DARK_GRAY, TextFormatting.ITALIC}));
            }
        }
    }
}

