/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.mixin;

import com.mojang.datafixers.util.Pair;
import com.vulp.tomes.enchantments.EnchantClueHolder;
import com.vulp.tomes.network.TomesPacketHandler;
import com.vulp.tomes.network.messages.ServerEnchantmentClueMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.EnchantmentContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.network.PacketDistributor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentContainer.class})
public class EnchantmentContainerMixin {
    @Shadow
    public int[] field_185001_h;
    @Shadow
    @Final
    public Random field_75169_l;
    @Shadow
    @Final
    public int[] field_185002_i;
    private static EnchantClueHolder HOLDER = new EnchantClueHolder();
    private static boolean ENCHANT_LATCH = true;

    @Inject(method={"getEnchantmentList"}, at={@At(value="RETURN")})
    public void getEnchantmentList(ItemStack stack, int enchantSlot, int level, CallbackInfoReturnable<List<EnchantmentData>> cir) {
        if (ENCHANT_LATCH) {
            List list = (List)cir.getReturnValue();
            if (!list.isEmpty()) {
                ArrayList<Pair<Enchantment, Integer>> cluedPairingList = new ArrayList<Pair<Enchantment, Integer>>(Collections.emptyList());
                for (EnchantmentData enchantmentData : list) {
                    cluedPairingList.add((Pair<Enchantment, Integer>)new Pair((Object)enchantmentData.field_76302_b, (Object)enchantmentData.field_76303_c));
                }
                HOLDER.setData(enchantSlot, cluedPairingList);
                EnchantmentData data = (EnchantmentData)list.get(this.field_75169_l.nextInt(list.size()));
                this.field_185001_h[enchantSlot] = Registry.field_212628_q.func_148757_b((Object)data.field_76302_b);
                this.field_185002_i[enchantSlot] = data.field_76303_c;
            }
            if (enchantSlot == 2) {
                this.field_185001_h = EnchantClueHolder.encodeClues(HOLDER, this.field_185001_h);
                TomesPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new ServerEnchantmentClueMessage(this.getThis().field_75152_c, this.field_185001_h));
                HOLDER = new EnchantClueHolder();
            }
        } else {
            ENCHANT_LATCH = true;
        }
    }

    @Inject(at={@At(value="TAIL", target="Lnet/minecraft/inventory/container/EnchantmentContainer;getEnchantmentList(Lnet/minecraft/item/ItemStack;II)Ljava/util/List;")}, method={"enchantItem"})
    public void enchantItem(PlayerEntity playerIn, int id, CallbackInfoReturnable<Boolean> cir) {
        ENCHANT_LATCH = false;
    }

    private EnchantmentContainer getThis() {
        return (EnchantmentContainer)this;
    }
}

