/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.mixin;

import com.google.common.collect.Lists;
import com.vulp.tomes.enchantments.TomeEnchantment;
import com.vulp.tomes.items.TomeItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.registry.Registry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentHelper.class})
public abstract class EnchantmentHelperMixin {
    @Inject(at={@At(value="HEAD")}, method={"buildEnchantmentList"}, cancellable=true)
    private static void buildEnchantmentList(Random randomIn, ItemStack itemStackIn, int level, boolean allowTreasure, CallbackInfoReturnable<List<EnchantmentData>> info) {
        if (itemStackIn.func_77973_b() instanceof TomeItem) {
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = new ArrayList(Collections.emptyList());
            for (Enchantment enchantment : Registry.field_212628_q) {
                if (!(enchantment instanceof TomeEnchantment) || enchantment.func_185261_e() && !allowTreasure || !enchantment.canApplyAtEnchantingTable(itemStackIn)) continue;
                list1.add(new EnchantmentData(enchantment, 1));
            }
            if (!list1.isEmpty()) {
                EnchantmentData data;
                while (list.isEmpty()) {
                    data = (EnchantmentData)WeightedRandom.func_76271_a((Random)randomIn, list1);
                    if (!((TomeEnchantment)data.field_76302_b).isActive()) {
                        list.add(data);
                    }
                    if (list.size() != list1.size()) continue;
                    info.setReturnValue((Object)list);
                }
                if (level > 8 + randomIn.nextInt(4)) {
                    while (list.size() < 2) {
                        data = (EnchantmentData)WeightedRandom.func_76271_a((Random)randomIn, list1);
                        if (!list.contains(data) && !((TomeEnchantment)data.field_76302_b).isActive()) {
                            list.add(data);
                        }
                        if (list.size() != list1.size()) continue;
                        info.setReturnValue((Object)list);
                    }
                }
                if (level >= 30) {
                    while (list.size() < 3) {
                        data = (EnchantmentData)WeightedRandom.func_76271_a((Random)randomIn, list1);
                        if (((TomeEnchantment)data.field_76302_b).isActive()) {
                            list.add(data);
                        }
                        if (list.size() != list1.size()) continue;
                        info.setReturnValue((Object)list);
                    }
                }
                if (level >= 40 + randomIn.nextInt(10)) {
                    while (list.size() < 4) {
                        data = (EnchantmentData)WeightedRandom.func_76271_a((Random)randomIn, list1);
                        if (!((TomeEnchantment)data.field_76302_b).isActive() && !list.contains(data)) {
                            list.add(data);
                        }
                        if (list.size() != list1.size()) continue;
                        info.setReturnValue((Object)list);
                    }
                }
            }
            info.setReturnValue((Object)list);
        }
    }
}

