/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.network.messages;

import com.vulp.tomes.items.TomeItem;
import com.vulp.tomes.network.messages.IMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class ServerActiveSpellMessage
implements IMessage<ServerActiveSpellMessage> {
    private ItemStack bookStack;
    private boolean mainHand;

    public ServerActiveSpellMessage() {
    }

    public ServerActiveSpellMessage(ItemStack bookStack, boolean mainHand) {
        this.bookStack = bookStack;
        this.mainHand = mainHand;
    }

    @Override
    public void encode(ServerActiveSpellMessage message, PacketBuffer buffer) {
        buffer.func_150788_a(message.bookStack);
        buffer.writeBoolean(message.mainHand);
    }

    @Override
    public ServerActiveSpellMessage decode(PacketBuffer buffer) {
        return new ServerActiveSpellMessage(buffer.func_150791_c(), buffer.readBoolean());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(ServerActiveSpellMessage message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                World world = Minecraft.func_71410_x().field_71439_g.func_130014_f_();
                TomeItem.clientCastActiveSpell(world, (PlayerEntity)player, new ItemStack[]{message.bookStack}, this.mainHand ? Hand.MAIN_HAND : Hand.OFF_HAND);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

