/*
 * Decompiled with CFR 0.152.
 */
package com.vulp.tomes.network.messages;

import com.vulp.tomes.network.messages.IMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class ServerSummonDespawnMessage
implements IMessage<ServerSummonDespawnMessage> {
    private int entityID;
    private int particleID;

    public ServerSummonDespawnMessage() {
    }

    public ServerSummonDespawnMessage(int entityID, int particleID) {
        this.entityID = entityID;
        this.particleID = particleID;
    }

    @Override
    public void encode(ServerSummonDespawnMessage message, PacketBuffer buffer) {
        buffer.writeInt(message.entityID);
        buffer.writeInt(message.particleID);
    }

    @Override
    public ServerSummonDespawnMessage decode(PacketBuffer buffer) {
        return new ServerSummonDespawnMessage(buffer.readInt(), buffer.readInt());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(ServerSummonDespawnMessage message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                World world = player.field_70170_p;
                Entity entity = world.func_73045_a(message.entityID);
                ParticleType particle = (ParticleType)Registry.field_212632_u.func_148745_a(message.particleID);
                if (entity != null && particle != null) {
                    world.func_195594_a((IParticleData)particle, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), (double)message.entityID, 0.0, 0.0);
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

